from django.conf import settings

from talos.rpc import bind
from qa.models.baiduxzh import BDAnswer


def get_mip_answer_sitemap(offset=0, limit=10000):

    answers = BDAnswer.objects.using(settings.SLAVE_DB_NAME).filter(is_recommend=True,
                                                                    is_submit=True). \
                  extra({'create_time': "DATE_FORMAT(create_time, '%%Y-%%d-%%m')"}).order_by('-create_time').prefetch_related("question")[offset: limit]

    res = []
    for answer in answers:
        if answer.question.is_online:
            res.append({
                "id": answer.original_id,
                "title": answer.question.title,
                "create_time": answer.create_time,
                "type": "mip_answer",
            })

    return res
