# -*- coding: utf8 -*-

import redis
from django.conf import settings
from django.utils import timezone

from talos.libs.datetime_utils import get_timestamp_or_none


_pool = redis.ConnectionPool(**settings.REDIS['social_cache'])
social_cache = redis.StrictRedis(connection_pool=_pool)


class SignalBlocker(object):
    """for some reason, we need to unregister post save signal when we save a model."""
    def __init__(self, signal, receiver, sender, **kwargs):
        self.signal = signal
        self.receiver = receiver
        self.sender = sender
        self.kwargs = kwargs

    def __enter__(self, *args, **kwargs):
        self.signal.disconnect(self.receiver, self.sender, **self.kwargs)

    def __exit__(self, *args, **kwargs):
        self.signal.connect(self.receiver, self.sender, **self.kwargs)


ts_now_as_score = lambda: get_timestamp_or_none(timezone.now())

def get_social_info(user):
    social_info = None
    if user:
        from social.models import SocialInfo
        social_info = SocialInfo(uid=user.id)
    return social_info