from gm_rpcd.internals.logging_integration import GMRpcdRequestInfoExtractor


from utils.rpc import get_current_user_by_session_key, get_current_user_by_rpcd_request
from user_hierarchy.models import UserEventLog


def status(request):
    data = {
        'ok': True,
        'errors': {
        }
    }

    try:
        UserEventLog.objects.count()
    except:
        data['errors']['mysql'] = 'failed'
        data['ok'] = False

    return data


class MimasRequestInfoExtractor(GMRpcdRequestInfoExtractor):

    def get_request_info(self, request):
        info = super(MimasRequestInfoExtractor, self).get_request_info(request)
        if not request.session_id:
            return info

        # _user = get_current_user_by_session_key(request.session_id)
        _user = get_current_user_by_rpcd_request(request)
        if not _user:
            return info

        info.update(**{'user_id': _user.id})
        return info
