# -*- coding: utf8 -*-

import datetime
from django.utils import timezone

from talos.models import ReplyCollect
from talos.models.topic.topicreply import TopicReply


def is_reply_num_gt_limit(user):
    # 查看用户在最近一分钟内回复是否超过limit条
    limit = 3
    reply_count = TopicReply.objects.filter(user_id=user.id,
                                            reply_date__gte=timezone.now() - datetime.timedelta(minutes=1)).count()
    return reply_count >= limit


def create_reply_collect(user_id, reply_user_id, topic_id, answer_id, create_time):
    create_time = datetime.datetime.strptime(create_time, '%Y-%m-%d %H:%M:%S.%f')
    ReplyCollect.objects.get_or_create(topic_reply_id=topic_id, answer_id=answer_id, defaults={
        'user_id': user_id, 'topic_reply_id': topic_id, 'reply_user_id': reply_user_id,
        'created_time': create_time
    })
