# -*- coding: utf-8 -*-
# @Author  : songzhenqi
from django.core.management.base import BaseCommand

from talos.tasks.diary_xml import diary_all


class Command(BaseCommand):
    help = '360日记数据同步'

    def add_arguments(self, parser):
        parser.add_argument('-s', '--steps', dest='step', type=int, default=800)
        parser.add_argument('-a', '--amounts', dest='amount', type=int, default=None)

    def handle(self, *args, **options):
        step = options['step']
        amount = options['amount']
        diary_all(step, amount)