#!/usr/bin/env python
# -*- coding: utf-8 -*-

from datetime import datetime, date, time

from django.core.management.base import BaseCommand
from gm_types.gaia import TOPIC_TYPE

from talos.models.diary import Diary
from talos.models.topic import Problem

today_date_time = datetime.combine(date.today(), time.min)


def _edit_diary_info():
    need_edit_diaries = Diary.objects.filter(
        is_online=True,
        operation_time__isnull=False,
        operation_time__gt=today_date_time
    ).only("id", "operation_time")

    print("edit diary begin")
    write_to_log_list = []
    print("assemble diary log begin")
    for diary in need_edit_diaries:
        _log = "diary update, id={diary_id} raw_operate_time={diary_operate_time} update_time={update_time}\n".format(
            diary_id=diary.id,
            diary_operate_time=diary.operation_time.strftime("%Y-%m-%d %H:%M:%S"),
            update_time=today_date_time.strftime("%Y-%m-%d %H:%M:%S")
        )
        write_to_log_list.append(_log)
    print("assemble diary log end")

    print("update diary operate_time begin")
    for diary in need_edit_diaries:
        diary.operation_time = today_date_time
        diary.save(update_fields=["operation_time"])
    print("update diary operate_time end")

    print("diary edit operate time write to file begin")
    with open("mimas_edit_diary_operate_time.log", "w") as f:
        f.writelines(write_to_log_list)
    print("diary edit operate time write to file end")

    print("edit diary end")


def _edit_topic_info():
    topic_type_list = [TOPIC_TYPE.ASK, TOPIC_TYPE.SHARE, TOPIC_TYPE.TOPIC]
    write_to_log_list = []
    need_edit_topic_diary_ids = set()

    need_edit_topics = Problem.objects.filter(
        is_online=True,
        diary_id__isnull=False,
        topic_type__in=topic_type_list,
        operation_date__isnull=False,
        operation_date__gt=today_date_time
    ).only("id", "diary_id", "operation_date")

    print("edit topic begin")

    print("assemble topic log begin")
    for topic in need_edit_topics:
        _log = "topic update,topic_id={topic_id} diary_id={diary_id} topic_raw_operate_time={topic_operate_time} update_time={update_time}\n".format(
            topic_id=topic.id,
            diary_id=topic.diary_id,
            topic_operate_time=topic.operation_date.strftime("%Y-%m-%d %H:%M:%S"),
            update_time=today_date_time.strftime("%Y-%m-%d %H:%M:%S")
        )
        write_to_log_list.append(_log)
        need_edit_topic_diary_ids.add(topic.diary_id)  # 不管日记本的手术时间咋样，都需要重置
    print("assemble topic log end")

    print("topic edit operate time write to file begin")
    with open("mimas_edit_topic_operate_time.log", "w") as f:
        f.writelines(write_to_log_list)
    print("topic edit operate time write to file end")

    print("update topic operate_date begin")
    for topic in need_edit_topics:
        topic.operation_date = today_date_time
        topic.save(update_fields=["operation_date"])
    print("update topic operate_date end")

    topic_diary_write_to_log_list = []
    topic_need_edit_diaries = Diary.objects.filter(id__in=need_edit_topic_diary_ids).only("id", "operation_time")
    for topic_diary in topic_need_edit_diaries:
        _log = "topic diary update, id={diary_id} raw_operate_time={diary_operate_time} update_time={update_time}\n".format(
            diary_id=topic_diary.id,
            diary_operate_time=topic_diary.operation_time.strftime("%Y-%m-%d %H:%M:%S"),
            update_time=today_date_time.strftime("%Y-%m-%d %H:%M:%S")
        )
        topic_diary_write_to_log_list.append(_log)

        print("topic diary edit operate time write to file begin")
        with open("mimas_edit_topic_diary_operate_time.log", "w") as f:
            f.writelines(topic_diary_write_to_log_list)
        print("topic diary operate time write to file end")

        print("update topic diary operate_time begin")
        for topic_diary in topic_need_edit_diaries:
            topic_diary.operation_time = today_date_time
            topic_diary.save(update_fields=["operation_time"])
        print("update topic diary operate_time end")

    print("edit topic end")


class Command(BaseCommand):
    def handle(self, *args, **options):
        print("BEGIN")

        _edit_diary_info()
        _edit_topic_info()

        print("END")
