
from django.core.management import BaseCommand
from django.conf import settings

from talos.models.diary import DiaryFavor
from talos.models.topic import ProblemFavor


class Command(BaseCommand):

    def handle(self, *args, **kwargs):

        PAGE_SIZE = 1000

        item = DiaryFavor.objects.using(settings.SLAVE_DB_NAME).raw("SELECT max(id) id FROM api_diaryfavor")
        max_id = item[0].id
        print(max_id)

        start_id = 0
        while start_id <= max_id:
            print(start_id)
            DiaryFavor.objects.raw("""
                UPDATE api_diaryfavor SET update_time=created_time
                WHERE
                    id >= {start_id} and id <= {end_id}
            """.format(start_id=start_id, end_id=start_id + PAGE_SIZE))
            start_id += PAGE_SIZE

        item = ProblemFavor.objects.using(settings.SLAVE_DB_NAME).raw("SELECT max(id) id FROM api_problemfavor")
        max_id = item[0].id
        print(max_id)

        start_id = 0
        while start_id <= max_id:
            print(start_id)
            ProblemFavor.objects.raw("""
                UPDATE api_problemfavor SET update_time=created_time
                WHERE
                    id >= {start_id} and id <= {end_id}
            """.format(start_id=start_id, end_id=start_id + PAGE_SIZE))
            start_id += PAGE_SIZE
