#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.core.management import BaseCommand, CommandError
from user_hierarchy.models import UserGrowthValue
from data_sync.user.user import sync_user_level


class Command(BaseCommand):
    """同步用户等级。"""

    def add_arguments(self, parser):
        parser.add_argument('-u', '--users', dest='user_ids', type=str)

    def handle(self, *args, **options):
        print("BEGIN")

        user_ids = options['user_ids']
        if not user_ids:
            raise CommandError("请指定用户id列表")

        try:
            user_ids = list(map(lambda x: int(x), user_ids.split(',')))
        except:
            raise CommandError("id列表格式错误")

        growth_value_ids = list(UserGrowthValue.objects.filter(user_id__in=user_ids).values_list("id", flat=True))

        print(growth_value_ids)
        sync_user_level(growth_value_ids)

        print("END")
