# -*- coding: UTF-8 -*-

from django.db import models
from gm_types.gaia import (
    REPORT_TYPE,
    REPORT_REASON,
    REPORT_ACTIONS
)

from .diary import Diary
from .topic import Problem
from .topic import TopicReply


class Report(models.Model):
    class Meta:
        verbose_name = u'80. 举报'
        verbose_name_plural = u'80. 举报'
        db_table = 'api_report'
        app_label = 'talos'

    user_id = models.IntegerField(null=True, blank=True, verbose_name=u"举报人")
    problem = models.ForeignKey(Problem, null=True, blank=True, related_name='report_topic', verbose_name=u"被举报的话题")
    diary = models.ForeignKey(Diary, null=True, blank=True, related_name='report_diary', verbose_name=u'被举报的日记本')
    topic_reply = models.ForeignKey(TopicReply, null=True, blank=True, related_name='report_reply',
                                    verbose_name=u"被举报的回复")
    type = models.CharField(max_length=1, verbose_name=u'举报类型', null=False, blank=False,
                            default=REPORT_TYPE.TOPIC, choices=REPORT_TYPE)
    reason = models.CharField(max_length=1, choices=REPORT_REASON, null=False, default=REPORT_REASON.AD,
                              verbose_name=u'举报原因')
    report_time = models.DateTimeField(auto_now_add=True, verbose_name=u'举报时间')
    is_handled = models.BooleanField(default=False, verbose_name=u'是否已经处理')
    action = models.CharField(max_length=1, choices=REPORT_ACTIONS, null=True, default=REPORT_ACTIONS.UNHANDLED,
                              verbose_name=u'处理动作')
