# -*- coding: UTF-8 -*-

from django.db import models


class SiteMap(models.Model):

    class Meta:
        verbose_name = u'sitemap数据存储'
        verbose_name_plural = u'sitemap数据存储'
        db_table = 'api_sitemap'
        app_label = 'talos'

    site_type = models.CharField(max_length=50, verbose_name=u'站点类型', null=False, blank=False)
    page_num = models.IntegerField(verbose_name='页数')
    data = models.TextField(null=False, verbose_name='数据：json字符串')

    create_time = models.DateTimeField(auto_now_add=True, verbose_name=u'创建时间')
