"""帖子评论"""

from django.db import models
from django.utils import timezone

from gm_types.mimas import TRACTATE_REPLY_SOURCE


class SoftArticleReply(models.Model):
    """新帖子评论相关"""

    class Meta:
        verbose_name = '新帖子(软文)评论相关'
        db_table = 'api_softarticle_reply'
        app_label = 'talos'

    softarticle_id = models.IntegerField(verbose_name="软文id", db_index=True, null=False)
    user_id = models.IntegerField(verbose_name="用户ID", null=True, db_index=True)
    merchant_id = models.CharField(verbose_name="商户id", db_index=True, max_length=64)
    doctor_id = models.CharField(verbose_name="医生id", db_index=True, max_length=64, null=True)

    top_id = models.IntegerField(verbose_name="当前评论的一级评论，一级评论为0", db_index=True)
    replied_id = models.IntegerField(verbose_name="被评论的评论id，一级评论为0", db_index=True)
    content = models.CharField(verbose_name="评论内容", max_length=512)

    is_read = models.BooleanField(verbose_name=u"是否已读", default=False)

    vote_num = models.IntegerField(verbose_name="点赞数", default=0)

    source_id = models.CharField(verbose_name="数据来源", max_length=12)  # hera、app
    is_reply = models.BooleanField(verbose_name=u"医生后台是否回复", default=False)
    is_vote = models.BooleanField(verbose_name=u'医生后台是否点赞', default=False)
    is_online = models.BooleanField(verbose_name=u"是否在线", default=True)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
    is_fake = models.BooleanField(verbose_name=u'是否是灌水评论', default=False)