
from django.db import models
from django.utils import timezone

from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import SUB_ARTICLE_PLATFORM
from talos.libs.datetime_utils import get_timestamp_or_none


class SubCategory(models.Model):
    """文章类目。"""

    class Meta:
        verbose_name = '文章类目'
        db_table = 'api_sub_category'
        app_label = 'talos'

    name = models.CharField(verbose_name=u'类名', default="", max_length=100)
    icon = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, verbose_name=u'图标', default="", max_length=100)

    is_online = models.BooleanField(verbose_name=u"是否在线", default=True)
    ordering = models.IntegerField(verbose_name=u"类型ID", default=99999)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)

    def to_dict(self):

        return {
            "id": self.id,
            "name": self.name,
            "icon": self.icon,
            "ordering": self.ordering,
            "is_online": self.is_online,
            "create_time": get_timestamp_or_none(self.create_time),
            "update_time": get_timestamp_or_none(self.update_time),
        }


class SubscriptArticle(models.Model):
    """公众号文章配置。"""

    class Meta:
        verbose_name = '公众号文章配置'
        db_table = 'api_sub_article'
        app_label = 'talos'

    name = models.CharField(verbose_name=u'名称', default="", max_length=200)
    title = models.CharField(verbose_name=u'标题', default="", max_length=200)

    url = models.CharField(verbose_name=u'文章地址', default="", max_length=200)
    image_url = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'图片地址')

    share_img = models.CharField(verbose_name=u'分享图片地址', default="", max_length=200)
    share_content = models.CharField(verbose_name=u'分享文案', default="", max_length=200)

    is_online = models.BooleanField(verbose_name=u"是否在线", default=True)
    is_header_article = models.BooleanField(verbose_name=u"是否是头条文章", default=False)

    platform = models.IntegerField(verbose_name=u"数据来源（爬取/后台创建）", max_length=12, choices=SUB_ARTICLE_PLATFORM)
    ordering = models.IntegerField(verbose_name=u"类型ID", default=99999)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)

    def to_dict(self):

        return {
            "id": self.id,
            "name": self.name,
            "title": self.title,
            "url": self.url,
            "image_url": self.image_url,

            "share_img": self.share_img,
            "share_content": self.share_content,

            "is_online": self.is_online,
            "is_header_article": self.is_header_article,

            "ordering": self.ordering,
            "platform": self.platform,

            "create_time": get_timestamp_or_none(self.create_time),
            "update_time": get_timestamp_or_none(self.update_time),
        }



class SubscriptArticleCategory(models.Model):
    """文章配类型。"""

    class Meta:
        verbose_name = '公众号文章配置'
        db_table = 'api_sub_article_category'
        app_label = 'talos'

    is_online = models.BooleanField(verbose_name=u"是否在线", default=True)

    article_id = models.IntegerField(verbose_name=u"文章ID")
    category_id = models.IntegerField(verbose_name=u"类型ID")

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class SubscriptArticleTag(models.Model):
    """文章标签"""

    class Meta:
        verbose_name = '公众号文章配置'
        db_table = 'api_sub_article_tag'
        app_label = 'talos'

    is_online = models.BooleanField(verbose_name=u"是否在线", default=True)

    article_id = models.IntegerField(verbose_name=u"文章ID")
    tag_id = models.IntegerField(verbose_name=u"标签ID")

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)

