#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from django.utils import timezone

from gm_types.mimas import (
    TRACTATE_STATUS,
    TRACTATE_CONTENT_LEVEL,
)


class TractateCheck(models.Model):
    """
    新帖子审核相关
    """
    class Meta:
        verbose_name = u'新帖子审核'
        db_table = 'api_tractate_check'
        app_label = 'talos'

    tractate_id = models.IntegerField(verbose_name="新帖子id", db_index=True)
    user_id = models.IntegerField(verbose_name=u"审核人id")
    content_level = models.CharField(verbose_name=u'内容分级', max_length=12, choices=TRACTATE_CONTENT_LEVEL,
                                     default=TRACTATE_CONTENT_LEVEL.NULL)
    status = models.CharField(verbose_name=u"审核状态", max_length=12, choices=TRACTATE_STATUS)  # 通过 or 拒绝 需要将状态同步到帖子表中
    check_content = models.TextField(verbose_name=u'运营审核备注', default='')
    title = models.CharField(max_length=128, verbose_name='消息标题', default='')
    send_message = models.TextField(verbose_name=u'发送短信信息', default='')
    check_time = models.DateTimeField(verbose_name=u'审核时间', default=timezone.now)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class TractateMessage(models.Model):
    """
    新帖子预设话述
    """
    class Meta:
        verbose_name = u'新帖子审核预设话述'
        db_table = 'api_tractate_message'
        app_label = 'talos'

    title = models.CharField(max_length=128, verbose_name='消息标题', default='')
    description = models.CharField(max_length=50, verbose_name='描述', default='')
    message = models.TextField(verbose_name=u'默认信息')
    content_level = models.CharField(verbose_name='内容等级', max_length=12, choices=TRACTATE_CONTENT_LEVEL,
                                     default=TRACTATE_CONTENT_LEVEL.NULL)
    is_delete = models.BooleanField(verbose_name=u'是否删除', default=False)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
