# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from talos.services.models.base import ServiceModelBase
from talos.services.models.hospital import Hospital
from talos.rpc import RPCMixin


class Doctor(RPCMixin, ServiceModelBase):

    __slots__ = [
        'id',
        'name',
        'portrait',
        'is_online',
        'doctor_type',
        'phone',
        'hospital',     # Hospital object
        'hospital_id',  # 兼容
        'user_id',
        'reply_limit',
        'title',  # 医生职称
        'department',  # 医生所在科室
    ]

    _auto_type_map_ = [
        ('hospital', Hospital.from_dict, Hospital.from_dict({'id': None})),
        ('user_id', int, 0),
    ]

    def __init__(self, id, name, portrait, is_online, doctor_type, phone,
                 hospital, hospital_id, user_id, reply_limit, title, department):
        self.id = id
        self.name = name
        self.portrait = portrait
        self.is_online = is_online
        self.doctor_type = doctor_type
        self.phone = phone
        self.hospital_id = hospital_id
        self.user_id = user_id
        self.hospital = hospital
        self.reply_limit = reply_limit
        self.title = title
        self.department = department

    def __bool__(self):
        return self.id is not None

    __nonzero__ = __bool__
