# -*- coding: utf8 -*-

from __future__ import unicode_literals, absolute_import, print_function

import json

from talos.services.base import ServiceBase
from talos.libs.utils import ObjFromDict
from talos.rpc import logging_exception


class OrderService(ServiceBase):

    @classmethod
    def get_order_from_order_id(cls, id):
        if id is None:
            return None
        try:
            result = cls.call_rpc('api/order/by_id', id=id)
        except Exception:
            return None
        return ObjFromDict(result)

    @classmethod
    def get_service_snapshot_by_order_id(cls, order_id):
        if order_id is None:
            return None
        try:
            result = cls.call_rpc('api/order/service_snapshot', id=order_id)
        except:
            return None

        snapshot = json.loads(result)
        return snapshot

    @classmethod
    def create_cashback_order_by_order_id(cls, order_id):
        if order_id is None:
            return
        try:
            cls.call_rpc('api/order/create_cashback_order', order_id=order_id)
        except:
            # fail  silently
            logging_exception()

    @classmethod
    def get_order_data_for_update_diary_operation_info(cls, order_id):
        """get order data when updating diary operation info.

        :param order_id:
        :return:
            {
                "order_id":,
                "doctor_id":,
                "doctor_name":,
                "hospital_id":,
                "hospital_name":,
                "price":,
                "service_id":,
                "service_name": ,
            }
        """
        if order_id is None:
            return None
        try:
            result = cls.call_rpc('api/order/get_data_for_update_diary', order_id=order_id)
        except Exception:
            return None

        return result
