# -*- coding: utf-8 -*-
"""service基类，所有的service继承该类"""


class BaseService(object):

    # 在基类中必须定义，不然使用会报错
    model = None

    @classmethod
    def get_by_id(cls, pk):
        try:
            return cls.model.objects.get(pk=pk)
        except cls.model.DoesNotExist:
            return None

    @classmethod
    def list_by_ids(cls, ids):

        return cls.model.objects.filter(pk__in=ids)

    @classmethod
    def list_objs_by_ids(cls, ids):

        return {
            obj.id: obj
            for obj in cls.list_by_ids(ids)
        }
