from collections import defaultdict

from talos.models.subscript_article.article import SubscriptArticle, \
    SubscriptArticleTag, SubscriptArticleCategory, SubscriptArticle, SubCategory
from talos.services.tag import TagService


class SubscriptArticleService(object):

    @classmethod
    def list_by_ids(cls, article_ids):

        articles = SubscriptArticle.objects.filter(id__in=article_ids).order_by("-ordering")

        articles_tags = cls.list_tags_by_ids(article_ids)

        res = []
        for item in articles:
            info = item.to_dict()

            tags = articles_tags.get(info["id"], [])
            info["tags"] = [{"id": tag.id, "name": tag.name} for tag in tags]
            res.append(info)

        return res

    @classmethod
    def get_by_id(cls, article_id):

        try:
            article = SubscriptArticle.objects.get(id=article_id)
        except:
            return {}

        info = article.to_dict()
        info["tags"] = cls.list_tags_by_id(article_id)

        return info

    @classmethod
    def list_tags_by_id(cls, article_id):
        """根据文章ID获取对应的文章的标签列表"""

        tag_ids = list(SubscriptArticleTag.objects.filter(article_id=article_id,
            is_online=True).values_list("tag_id", flat=True))

        tags_dict_info = TagService.get_tags_dict_by_tag_ids(tag_ids)

        tags = [tags_dict_info.get(tag_id, None) for tag_id in tag_ids]

        return  list(filter(lambda i: i is not None, tags))

    @classmethod
    def list_tags_by_ids(cls, article_ids):
        """根据文章ID列表获取对应的文章的标签列表。

        @return: 返回参数，字典
            {
                artile_id: [{id: 1, name: "标签名", "type": 1, ....}],
                artile_id: [{id: 2, name: "标签名", "type": 1, ....}],
            }
        """

        articles_tag = SubscriptArticleTag.objects.filter(article_id__in=article_ids,
            is_online=True).values("article_id", "tag_id")

        articles_tags = defaultdict(list)
        tag_ids = []
        for item in articles_tag:
            articles_tags[item["article_id"]].append(item["tag_id"])
            tag_ids.append(item["tag_id"])

        tags_dict_info = TagService.get_tags_dict_by_tag_ids(tag_ids)

        res = {}
        for article_id in article_ids:

            tag_ids = articles_tags.get(article_id, [])
            tags = [tags_dict_info.get(tag_id, None) for tag_id in tag_ids]

            res[article_id] = list(filter(lambda i: i is not None, tags))

        return res

    @classmethod
    def list_category_by_id(cls, article_id):

        category_ids = SubscriptArticleCategory.objects.filter(is_online=True,
            article_id=article_id).values_list("category_id", flat=True)

        categoties = SubCategory.objects.filter(id__in=category_ids, is_online=True).order_by("-ordering")

        res = []
        for item in categoties:
            res.append(item.to_dict())

        return res


class SubscriptArticleCategoryService(object):

    @classmethod
    def list(cls):

        category_ids = SubscriptArticleCategory.objects.filter(is_online=True).values_list("category_id", flat=True)

        categoties = SubCategory.objects.filter(id__in=category_ids, is_online=True).order_by("-ordering")

        res = []
        for item in categoties:
            res.append(item.to_dict())

        return res
