-- MySQL dump 10.13  Distrib 5.6.33, for debian-linux-gnu (x86_64)
--
-- Host: rdsfewzdmf0jfjp9un8xj.mysql.rds.aliyuncs.com    Database: zhengxing
-- ------------------------------------------------------
-- Server version   5.6.16-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
SET @MYSQLDUMP_TEMP_LOG_BIN = @@SESSION.SQL_LOG_BIN;
SET @@SESSION.SQL_LOG_BIN= 0;
--
-- GTID state at the beginning of the backup 
--

SET @@GLOBAL.GTID_PURGED='00806bbb-ff47-11e6-937a-7cd30abdad6e:1-311071898,
2dc75acc-33aa-11e5-9e6c-1051721d3b5a:1-513342444,
2f0e454b-3fdb-11e6-b340-008cfaf6f120:1-67431759,
2f6a5f6a-67e4-11e6-b850-6c92bf2f7f4c:1-769504491,
333b238d-33aa-11e5-9e6c-288023a0f5cc:1-189566832,
b1c5dae9-f212-11e4-b2b5-ac853d9f53a6:1-26839245,
c09d14a0-f212-11e4-b2b5-ac853d9d546b:1-2';

--
-- Table structure for table `api_activity`
--

DROP TABLE IF EXISTS `api_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `banner` varchar(128) NOT NULL,
  `description` longtext NOT NULL,
  `points` int(11) NOT NULL,
  `start_time` datetime(6) NOT NULL,
  `end_time` datetime(6) DEFAULT NULL,
  `is_online` tinyint(1) NOT NULL,
  `show_win_list` tinyint(1) NOT NULL,
  `win_limit` int(11) NOT NULL,
  `show_topics` tinyint(1) NOT NULL,
  `participate_limit` int(11) NOT NULL,
  `participants` int(11) NOT NULL,
  `doctor_id` varchar(100) DEFAULT NULL,
  `description_richtext` longtext,
  `act_type` varchar(16) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `doctor_id_refs_id_b5d13250` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=346 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_activitywinlist`
--

DROP TABLE IF EXISTS `api_activitywinlist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_activitywinlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) NOT NULL,
  `person_id` char(32) NOT NULL,
  `topic` int(11) NOT NULL,
  `created_at` datetime(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `person_id_refs_id_ef9fd85f` (`person_id`),
  KEY `activity_id_refs_id_2b42bce4` (`activity_id`),
  CONSTRAINT `activity_id_refs_id_2b42bce4` FOREIGN KEY (`activity_id`) REFERENCES `api_activity` (`id`),
  CONSTRAINT `person_id_refs_id_ef9fd85f` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=305 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_article`
--

DROP TABLE IF EXISTS `api_article`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_article` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `article_id` int(11) DEFAULT NULL,
  `article_type` varchar(10) NOT NULL,
  `is_online` tinyint(1) NOT NULL,
  `created_time` datetime(6) NOT NULL,
  `last_modified` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `article_id` (`article_id`)
) ENGINE=InnoDB AUTO_INCREMENT=238 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_columncard`
--

DROP TABLE IF EXISTS `api_columncard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_columncard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `article_id` int(11) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `doctor_id` varchar(100) DEFAULT NULL,
  `hospital_id` varchar(100) DEFAULT NULL,
  `answer_id` int(11) DEFAULT NULL,
  `rankboard_id` int(11) DEFAULT NULL,
  `diary_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_columncard_e669cc35` (`article_id`),
  KEY `api_columncard_5a8e60a2` (`service_id`),
  KEY `api_columncard_3505b1b3` (`doctor_id`),
  KEY `api_columncard_4963442f` (`hospital_id`),
  KEY `api_columncard_8fba58e3` (`answer_id`),
  KEY `api_columncard_66ee2858` (`rankboard_id`),
  CONSTRAINT `article_id_refs_id_6d5406c6` FOREIGN KEY (`article_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1453 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_columnist`
--

DROP TABLE IF EXISTS `api_columnist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_columnist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `introduction` varchar(50) DEFAULT NULL,
  `is_online` tinyint(1) NOT NULL,
  `profession` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `api_columnist_1ffdedc6` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_columntab`
--

DROP TABLE IF EXISTS `api_columntab`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_columntab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(10) DEFAULT NULL,
  `is_online` tinyint(1) NOT NULL,
  `order` int(11) NOT NULL,
  `created_time` datetime(6) NOT NULL,
  `last_modified` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_columntabtag`
--

DROP TABLE IF EXISTS `api_columntabtag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_columntabtag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `column_tab_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `api_columntabtag_b3de87b0` (`column_tab_id`),
  CONSTRAINT `column_tab_id_refs_id_80cb683a` FOREIGN KEY (`column_tab_id`) REFERENCES `api_columntab` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=538 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_diary`
--

DROP TABLE IF EXISTS `api_diary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_diary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `raw_doctor` varchar(200) NOT NULL,
  `raw_hospital` varchar(200) NOT NULL,
  `rating` float NOT NULL,
  `comment` longtext NOT NULL,
  `price` int(11) NOT NULL,
  `created_time` datetime NOT NULL,
  `last_modified` datetime NOT NULL,
  `operation_time` datetime DEFAULT NULL,
  `is_fake_operation_time` tinyint(1) NOT NULL,
  `pre_operation_image` varchar(128) DEFAULT NULL,
  `post_operation_image` varchar(128) DEFAULT NULL,
  `is_headline` tinyint(1) NOT NULL,
  `is_online` tinyint(1) NOT NULL,
  `note` longtext NOT NULL,
  `reply_num` int(11) NOT NULL,
  `doctor_id` varchar(100) DEFAULT NULL,
  `hospital_id` varchar(100) DEFAULT NULL,
  `service_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `is_sink` tinyint(1) NOT NULL,
  `order_id` varchar(12) DEFAULT NULL,
  `is_identification` tinyint(1) NOT NULL,
  `is_spam` tinyint(1) NOT NULL,
  `is_essence` tinyint(1) NOT NULL,
  `last_topic_add_time` datetime(6) DEFAULT NULL,
  `pre_operation_image_for_doctor` varchar(128) DEFAULT NULL,
  `post_operation_image_for_doctor` varchar(128) DEFAULT NULL,
  `operation_effect_rating` float NOT NULL,
  `doctor_attitude_rating` float NOT NULL,
  `hospital_env_rating` float NOT NULL,
  `like_num` int(11) DEFAULT '0',
  `sticky_post` tinyint(1) NOT NULL DEFAULT '0',
  `headline_time` datetime DEFAULT NULL,
  `rate_count` int(11) NOT NULL DEFAULT '0',
  `is_choice` tinyint(1) NOT NULL DEFAULT '0',
  `is_choice_content` longtext NOT NULL,
  `audit_status` varchar(1) NOT NULL DEFAULT '0',
  `audit_time` datetime DEFAULT NULL,
  `content_level` varchar(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_diary_order_id_uniq` (`order_id`),
  KEY `api_diary_65fd7b3f` (`is_headline`),
  KEY `api_diary_8eaa2aaf` (`is_online`),
  KEY `api_diary_d4d6bd50` (`doctor_id`),
  KEY `api_diary_8a738e00` (`hospital_id`),
  KEY `api_diary_b0dc1e29` (`service_id`),
  KEY `api_diary_e8701ad4` (`user_id`),
  KEY `api_diary_2441662c` (`is_sink`),
  KEY `api_diary_69dfcb07` (`order_id`),
  KEY `api_diary_4a08d251` (`is_identification`),
  KEY `api_diary_f4e29bc3` (`is_spam`),
  KEY `IDX_IS_HEADLINE_USER_ID` (`is_headline`,`user_id`),
  KEY `idx_created_time` (`created_time`),
  KEY `api_diary_doctor_id_is_online` (`doctor_id`,`is_online`),
  KEY `api_diary_service_id_is_online` (`service_id`,`is_online`),
  CONSTRAINT `api_diary_doctor_id_7b8b2458201854a4_fk_api_doctor_id` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`),
  CONSTRAINT `api_diary_hospital_id_17239b6f90d1b98f_fk_api_hospital_id` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`),
  CONSTRAINT `api_diary_order_id_6ba07cd84ab39192_fk_api_order_id` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`),
  CONSTRAINT `api_diary_service_id_57326b3d03826c1_fk_api_service_id` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`),
  CONSTRAINT `api_diary_user_id_49c7edf9824e590e_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15397277 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_diary_tags`
--

DROP TABLE IF EXISTS `api_diary_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_diary_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `diary_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `diary_id` (`diary_id`,`tag_id`),
  KEY `api_diary_tags_52d39f23` (`diary_id`),
  KEY `api_diary_tags_76f094bc` (`tag_id`),
  CONSTRAINT `api_diary_tags_diary_id_3ef4503e836a8cdc_fk_api_diary_id` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`),
  CONSTRAINT `api_diary_tags_tag_id_282718128a0661cd_fk_api_tag_id` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9134760 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_diarycheck`
--

DROP TABLE IF EXISTS `api_diarycheck`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_diarycheck` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `diary_id` int(11) NOT NULL,
  `person_id` char(32) NOT NULL,
  `check_time` datetime(6) NOT NULL,
  `content_level` varchar(8) NOT NULL,
  `check_content` longtext,
  `title` varchar(128) NOT NULL,
  `send_message` longtext,
  PRIMARY KEY (`id`),
  KEY `diary_id_refs_id_751494ff` (`diary_id`),
  KEY `person_id_refs_id_6d45e406` (`person_id`),
  CONSTRAINT `diary_id_refs_id_751494ff` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`),
  CONSTRAINT `person_id_refs_id_6d45e406` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=242431 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_diaryfavor`
--

DROP TABLE IF EXISTS `api_diaryfavor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_diaryfavor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `diary_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_diaryfavor_user_id_1304586c6f654f35_uniq` (`user_id`,`diary_id`),
  KEY `api_diaryfavor_diary_id_7403b36a7b4e4810_fk_api_diary_id` (`diary_id`),
  CONSTRAINT `api_diaryfavor_diary_id_7403b36a7b4e4810_fk_api_diary_id` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`),
  CONSTRAINT `api_diaryfavor_user_id_4d67cfef0e84f199_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16714 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_diarymessage`
--

DROP TABLE IF EXISTS `api_diarymessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_diarymessage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL,
  `title` varchar(128) NOT NULL,
  `message` longtext NOT NULL,
  `is_delete` tinyint(1) NOT NULL,
  `level` varchar(8) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=207 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_diaryoperate`
--

DROP TABLE IF EXISTS `api_diaryoperate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_diaryoperate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `diary_id` int(11) DEFAULT NULL,
  `operate_time` datetime NOT NULL,
  `operation` varchar(1) NOT NULL,
  `topic` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_diaryoperate_diary` (`diary_id`),
  CONSTRAINT `diary_id_refs_id` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4339076 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_diaryrank`
--

DROP TABLE IF EXISTS `api_diaryrank`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_diaryrank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `diary_id` int(11) NOT NULL,
  `heat_score` double NOT NULL,
  `additional_score` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `diary_id` (`diary_id`),
  CONSTRAINT `diary_id_refs_id_b27e95b0` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75299 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_diaryvote`
--

DROP TABLE IF EXISTS `api_diaryvote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_diaryvote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `diary_id` int(11) NOT NULL,
  `vote_time` datetime(6) NOT NULL,
  `unread` tinyint(1) NOT NULL,
  `is_fake` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`diary_id`),
  KEY `idx_vote_time` (`vote_time`),
  KEY `api_diaryvote_67548958` (`diary_id`)
) ENGINE=InnoDB AUTO_INCREMENT=973930 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_draft`
--

DROP TABLE IF EXISTS `api_draft`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_draft` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `update_time` datetime NOT NULL,
  `is_show` tinyint(1) NOT NULL,
  `diary_id` int(11) DEFAULT NULL,
  `content` longtext NOT NULL,
  `tags` varchar(64) DEFAULT NULL,
  `images` longtext,
  `zone_tag` int(11) DEFAULT NULL,
  `cover` varchar(100) DEFAULT NULL,
  `person_id` varchar(32) DEFAULT NULL,
  `video` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_draft_ref_api_diary` (`diary_id`),
  KEY `api_draft_ref_api_person` (`person_id`),
  CONSTRAINT `api_draft_ref_api_diary` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`),
  CONSTRAINT `api_draft_ref_api_person` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=123744 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_filterword`
--

DROP TABLE IF EXISTS `api_filterword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_filterword` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `word` varchar(100) NOT NULL,
  `add_time` datetime NOT NULL,
  `is_filter` tinyint(1) NOT NULL,
  `in_user_name` tinyint(1) NOT NULL,
  `in_topic_content` tinyint(1) NOT NULL,
  `in_topic_reply` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=376 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_live_channel`
--

DROP TABLE IF EXISTS `api_live_channel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_live_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` char(32) NOT NULL,
  `created_time` datetime(6) NOT NULL,
  `updated_time` datetime(6) NOT NULL,
  `title` varchar(128) NOT NULL,
  `cover_url` varchar(128) NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`),
  KEY `api_live_channel_41e5f0d8` (`created_time`),
  KEY `api_live_channel_b7cc06d7` (`updated_time`),
  CONSTRAINT `person_id_refs_id_4aa13a0a` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_live_msg`
--

DROP TABLE IF EXISTS `api_live_msg`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_live_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` char(32) NOT NULL,
  `stream_id` int(11) NOT NULL,
  `msg` varchar(128) NOT NULL,
  `created_time` datetime(6) NOT NULL,
  `type` int(11) NOT NULL,
  `is_vest_send` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `api_live_msg_16f39487` (`person_id`),
  KEY `api_live_msg_6895d443` (`stream_id`),
  KEY `api_live_msg_41e5f0d8` (`created_time`),
  CONSTRAINT `person_id_refs_id_9204dd46` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`),
  CONSTRAINT `stream_id_refs_id_bb75766a` FOREIGN KEY (`stream_id`) REFERENCES `api_live_stream` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=79777 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_live_stream`
--

DROP TABLE IF EXISTS `api_live_stream`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_live_stream` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel_id` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_time` datetime(6) NOT NULL,
  `updated_time` datetime(6) NOT NULL,
  `stream_key` varchar(128) NOT NULL,
  `save_replay_url` varchar(128) NOT NULL,
  `title` varchar(128) NOT NULL,
  `cover_url` varchar(128) NOT NULL,
  `topic_id` int(11) DEFAULT NULL,
  `max_view_num` int(11) NOT NULL,
  `replay_danmu` longtext,
  `is_finish` tinyint(1) DEFAULT '1',
  `hospital_id` varchar(100) DEFAULT NULL,
  `service_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `topic_id` (`topic_id`),
  KEY `api_live_stream_9e85bf2d` (`channel_id`),
  KEY `api_live_stream_68a4455c` (`stream_key`),
  KEY `api_live_stream_f8e569df` (`save_replay_url`),
  KEY `api_live_stream_41e5f0d8` (`created_time`),
  KEY `api_live_stream_b7cc06d7` (`updated_time`),
  CONSTRAINT `channel_id_refs_id_3d8db62e` FOREIGN KEY (`channel_id`) REFERENCES `api_live_channel` (`id`),
  CONSTRAINT `topic_id_refs_id_5b3218db` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_live_white_list`
--

DROP TABLE IF EXISTS `api_live_white_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_live_white_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `is_online` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  CONSTRAINT `user_id_refs_id_0a276328` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_pgcclassify`
--

DROP TABLE IF EXISTS `api_pgcclassify`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_pgcclassify` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `ordering` int(11) NOT NULL,
  `is_online` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_preoperationimage`
--

DROP TABLE IF EXISTS `api_preoperationimage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_preoperationimage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) DEFAULT NULL,
  `image_url` varchar(300) NOT NULL,
  `diary_id` int(11) DEFAULT NULL,
  `taken_time` datetime(6),
  `is_cover` tinyint(1) DEFAULT '0',
  `cover_image_url` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_preoperationimage_57732028` (`topic_id`),
  KEY `api_preoperationimage_52d39f23` (`diary_id`),
  CONSTRAINT `api_preoperationimage_diary_id_55cfb44fe258a4ff_fk_api_diary_id` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`),
  CONSTRAINT `topic_id_refs_id_c84b83e3` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4389224 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_problem`
--

DROP TABLE IF EXISTS `api_problem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_problem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `title` varchar(200) CHARACTER SET utf8mb4 DEFAULT NULL,
  `ask` longtext CHARACTER SET utf8mb4 NOT NULL,
  `answer` longtext CHARACTER SET utf8mb4 NOT NULL,
  `bodypart_subitem_id` int(11) DEFAULT NULL,
  `other_item` varchar(100) DEFAULT '',
  `created_time` datetime NOT NULL,
  `last_modified` datetime NOT NULL,
  `flag` varchar(1) NOT NULL DEFAULT 'n',
  `status` varchar(1) NOT NULL DEFAULT 'n',
  `assigned_doctor_id` int(11) DEFAULT NULL,
  `has_answer` tinyint(1) NOT NULL DEFAULT '0',
  `is_viewed` tinyint(1) NOT NULL DEFAULT '1',
  `collect_num` int(11) NOT NULL DEFAULT '0',
  `is_online` tinyint(1) NOT NULL,
  `can_video_cover` tinyint(1) NOT NULL DEFAULT '1',
  `is_public` tinyint(1) NOT NULL,
  `patient_image` varchar(255) DEFAULT NULL,
  `doctor_id` varchar(100) DEFAULT NULL,
  `selected_qa` tinyint(1) NOT NULL,
  `is_topic` tinyint(1) NOT NULL,
  `doctor_num` int(11) NOT NULL,
  `reply_num` int(11) NOT NULL,
  `private_status` varchar(1) NOT NULL,
  `is_recommend` tinyint(1) NOT NULL,
  `is_alerted` tinyint(1) NOT NULL,
  `is_recommend_all` tinyint(1) NOT NULL,
  `topic_type` varchar(10) NOT NULL,
  `order` int(11) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `link_doctor_id` varchar(100) DEFAULT NULL,
  `link_doctor_item_id` int(11) DEFAULT NULL,
  `activity_title` varchar(100) DEFAULT NULL,
  `jump_type` varchar(1) NOT NULL,
  `jump_value` varchar(100) DEFAULT NULL,
  `has_activity` tinyint(1) NOT NULL,
  `raw_doctor` varchar(200) NOT NULL,
  `link_hospital_id` varchar(100) DEFAULT NULL,
  `raw_hospital` varchar(200) NOT NULL,
  `rating` int(11) NOT NULL,
  `price` int(11) NOT NULL,
  `author_reply_num` int(11) NOT NULL,
  `is_sink` tinyint(1) NOT NULL,
  `is_headline` tinyint(1) NOT NULL,
  `pre_operation_image` varchar(128) DEFAULT NULL,
  `post_operation_image` varchar(128) DEFAULT NULL,
  `operation_time` date DEFAULT NULL,
  `channel_headline` tinyint(1) NOT NULL,
  `body_part_id` int(11) DEFAULT NULL,
  `diary_id` int(11) DEFAULT NULL,
  `is_spam` tinyint(1) NOT NULL,
  `review_status` int(11) DEFAULT '0',
  `activity_id` int(11) DEFAULT NULL,
  `device_id` varchar(64) DEFAULT NULL,
  `is_mixed` tinyint(1) DEFAULT '0',
  `share_id` int(11) DEFAULT NULL,
  `audit_status` tinyint(1) NOT NULL DEFAULT '1',
  `pgc_classfy_id` int(11) DEFAULT NULL,
  `answer_richtext` longtext,
  PRIMARY KEY (`id`),
  KEY `api_problem_403f60f` (`user_id`),
  KEY `api_problem_7be581d8` (`title`(191)),
  KEY `api_problem_1f5b297` (`bodypart_subitem_id`),
  KEY `api_problem_6ac32844` (`last_modified`),
  KEY `api_problem_111c90f9` (`flag`),
  KEY `api_problem_36528e23` (`status`),
  KEY `api_problem_248d0569` (`assigned_doctor_id`),
  KEY `api_problem_5e374160` (`has_answer`),
  KEY `api_problem_587e071` (`other_item`),
  KEY `api_problem_81633e5` (`created_time`),
  KEY `api_problem_bd7c901` (`doctor_id`),
  KEY `api_problem_6f1d73c2` (`service_id`),
  KEY `api_problem_7934b8b` (`link_doctor_id`),
  KEY `api_problem_7ce4e964` (`link_doctor_item_id`),
  KEY `api_problem_a9c51314` (`link_hospital_id`),
  KEY `api_problem_dc579157` (`private_status`),
  KEY `api_problem_90b3c138` (`is_online`),
  KEY `api_problem_44e36594` (`is_recommend`),
  KEY `api_problem_22f23d62` (`is_public`),
  KEY `api_problem_40e6e90b` (`is_headline`),
  KEY `api_problem_e2e6c387` (`topic_type`),
  KEY `api_problem_5c8cece0` (`is_recommend_all`),
  KEY `api_problem_d52e7d9` (`channel_headline`),
  KEY `api_problem_932798f7` (`body_part_id`),
  KEY `api_problem_52d39f23` (`diary_id`),
  KEY `api_problem_f4e29bc3` (`is_spam`),
  KEY `IDX_IS_RECOMMEND_ALL_LAST_MODIFIED` (`is_recommend_all`,`last_modified`),
  KEY `api_problem_diary_flag_is_online` (`diary_id`,`flag`,`is_online`),
  KEY `activity_id_refs_id_14d4dbff` (`activity_id`),
  KEY `share_id_refs_id_8baed6da` (`share_id`),
  KEY `pgc_classfy_id_refs_id_014d1a14` (`pgc_classfy_id`),
  CONSTRAINT `activity_id_refs_id_14d4dbff` FOREIGN KEY (`activity_id`) REFERENCES `api_activity` (`id`),
  CONSTRAINT `api_problem_body_part_id_329b12a955853ab0_fk_api_bodypart_id` FOREIGN KEY (`body_part_id`) REFERENCES `api_bodypart` (`id`),
  CONSTRAINT `api_problem_diary_id_35e894f826ea5ae9_fk_api_diary_id` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`),
  CONSTRAINT `pgc_classfy_id_refs_id_014d1a14` FOREIGN KEY (`pgc_classfy_id`) REFERENCES `api_pgcclassify` (`id`),
  CONSTRAINT `share_id_refs_id_8baed6da` FOREIGN KEY (`share_id`) REFERENCES `api_share` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19167177 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_problem_operations`
--

DROP TABLE IF EXISTS `api_problem_operations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_problem_operations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `problem_id` int(11) NOT NULL,
  `itemwiki_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_problem_operations_problem_id_726545bf070daae_uniq` (`problem_id`,`itemwiki_id`),
  KEY `api_problem_operations_a9b3a92a` (`problem_id`),
  KEY `api_problem_operations_5a8acebb` (`itemwiki_id`),
  CONSTRAINT `itemwiki_id_refs_id_b152659e` FOREIGN KEY (`itemwiki_id`) REFERENCES `api_itemwiki` (`id`),
  CONSTRAINT `problem_id_refs_id_3ca7092d` FOREIGN KEY (`problem_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44106 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_problemfavor`
--

DROP TABLE IF EXISTS `api_problemfavor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_problemfavor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `problem_id` int(11) NOT NULL,
  `created_time` datetime(6) NOT NULL,
  `is_deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_problemfavor_user_id_4b4c22ed_uniq` (`user_id`,`problem_id`)
) ENGINE=InnoDB AUTO_INCREMENT=89613 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_problemtag`
--

DROP TABLE IF EXISTS `api_problemtag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_problemtag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `problem_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `api_problemtag_919b1d80` (`problem_id`),
  KEY `api_problemtag_76f094bc` (`tag_id`),
  KEY `IDX_TAG_ID_PROBLEM_ID` (`tag_id`,`problem_id`),
  CONSTRAINT `api_problemtag_problem_id_114b93b7cd5af546_fk_api_problem_id` FOREIGN KEY (`problem_id`) REFERENCES `api_problem` (`id`),
  CONSTRAINT `api_problemtag_tag_id_6b4c3ef57a0e9ab3_fk_api_tag_id` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2211932 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_reply_collect`
--

DROP TABLE IF EXISTS `api_reply_collect`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_reply_collect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_time` datetime(6) NOT NULL,
  `topic_reply_id` int(11) DEFAULT NULL,
  `answer_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `reply_user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `topic_reply_id` (`topic_reply_id`),
  UNIQUE KEY `answer_id` (`answer_id`),
  KEY `api_reply_collect_41e5f0d8` (`created_time`),
  KEY `api_reply_collect_59317d5a` (`user_id`,`created_time`),
  KEY `api_reply_collect_2fc8ef42` (`reply_user_id`,`created_time`)
) ENGINE=InnoDB AUTO_INCREMENT=6529288 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_replyheadline`
--

DROP TABLE IF EXISTS `api_replyheadline`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_replyheadline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reply_id` int(11) NOT NULL,
  `is_online` tinyint(1) NOT NULL,
  `create_time` datetime(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `reply_id_refs_id_0b18d844` (`reply_id`),
  CONSTRAINT `reply_id_refs_id_0b18d844` FOREIGN KEY (`reply_id`) REFERENCES `api_topicreply` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=292 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_report`
--

DROP TABLE IF EXISTS `api_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `problem_id` int(11) DEFAULT NULL,
  `topic_reply_id` int(11) DEFAULT NULL,
  `report_time` datetime NOT NULL,
  `is_handled` tinyint(1) NOT NULL,
  `type` varchar(1) NOT NULL,
  `reason` varchar(1) NOT NULL,
  `action` varchar(1) DEFAULT NULL,
  `diary_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_report_403f60f` (`user_id`),
  KEY `api_report_564c56d6` (`problem_id`),
  KEY `api_report_1026ded9` (`topic_reply_id`),
  KEY `api_report_diary_id_refs_id_51975aea` (`diary_id`),
  CONSTRAINT `api_report_diary_id_refs_id_51975aea` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`),
  CONSTRAINT `problem_id_refs_id_364e074f` FOREIGN KEY (`problem_id`) REFERENCES `api_problem` (`id`),
  CONSTRAINT `topic_reply_id_refs_id_7d27eae2` FOREIGN KEY (`topic_reply_id`) REFERENCES `api_topicreply` (`id`),
  CONSTRAINT `user_id_refs_id_1ae6219b` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63058 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_streamtag`
--

DROP TABLE IF EXISTS `api_streamtag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_streamtag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `live_stream_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `api_streamtag_05b8459a` (`live_stream_id`),
  KEY `api_streamtag_5659cca2` (`tag_id`),
  CONSTRAINT `live_stream_id_refs_id_910c7574` FOREIGN KEY (`live_stream_id`) REFERENCES `api_live_stream` (`id`),
  CONSTRAINT `tag_id_refs_id_55724010` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_topic_video`
--

DROP TABLE IF EXISTS `api_topic_video`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_topic_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) DEFAULT NULL,
  `video_url` varchar(128) NOT NULL,
  `video_pic` varchar(128) NOT NULL,
  `persistentId` varchar(128) NOT NULL,
  `persistent_status` int(11) NOT NULL,
  `water_url` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `topic_id` (`topic_id`),
  KEY `api_topic_video_2014e333` (`persistent_status`),
  CONSTRAINT `topic_id_refs_id_646d4ca8` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2943 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_topicimage`
--

DROP TABLE IF EXISTS `api_topicimage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_topicimage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) NOT NULL,
  `image_url` varchar(300) NOT NULL,
  `taken_time` datetime(6),
  `image_type` int(11) NOT NULL,
  `is_cover` tinyint(1) DEFAULT '0',
  `cover_image_url` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_topicimage_57732028` (`topic_id`),
  KEY `IDX_IM_TO_TA` (`image_url`(255),`topic_id`,`taken_time`),
  CONSTRAINT `topic_id_refs_id_17f25263` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1987094 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_topicrankingscore`
--

DROP TABLE IF EXISTS `api_topicrankingscore`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_topicrankingscore` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reply_score` double NOT NULL,
  `vote_score` double NOT NULL,
  `topic_id` int(11) NOT NULL,
  `last_modified` datetime(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `topic_id` (`topic_id`),
  CONSTRAINT `fk_topic_id` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=223435 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_topicreply`
--

DROP TABLE IF EXISTS `api_topicreply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_topicreply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `problem_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `doctor_id` varchar(100) DEFAULT NULL,
  `replied_topic_id` int(11) DEFAULT NULL,
  `content` longtext CHARACTER SET utf8mb4 NOT NULL,
  `is_new` tinyint(1) NOT NULL,
  `like_num` int(11) NOT NULL,
  `dislike_num` int(11) NOT NULL,
  `reply_date` datetime NOT NULL,
  `image` longtext,
  `audio` longtext,
  `commented_reply_id` int(11) DEFAULT NULL,
  `is_topic_append` tinyint(1) NOT NULL,
  `hospital_id` varchar(100) DEFAULT NULL,
  `is_spam` tinyint(1) NOT NULL,
  `is_online` tinyint(1) NOT NULL DEFAULT '1',
  `diary_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_topicreply_564c56d6` (`problem_id`),
  KEY `api_topicreply_403f60f` (`user_id`),
  KEY `api_topicreply_bd7c901` (`doctor_id`),
  KEY `api_topicreply_3916d362` (`replied_topic_id`),
  KEY `api_topicreply_143f683a` (`commented_reply_id`),
  KEY `api_topicreply_bae8d80b` (`is_topic_append`),
  KEY `api_topicreply_67e8a5e6` (`is_new`),
  KEY `api_topicreply_f5322262` (`reply_date`),
  KEY `api_topicreply_8a738e00` (`hospital_id`),
  KEY `api_topicreply_f4e29bc3` (`is_spam`),
  KEY `IDX_USER_ID_PROBLEM_ID` (`user_id`,`problem_id`),
  KEY `IDX_DOCTOR_ID_PROBLEM_ID` (`doctor_id`,`problem_id`),
  KEY `api_topicreply_diary_id_reply_date` (`diary_id`,`reply_date`),
  CONSTRAINT `api_topicreply_diary_id_refs_api_diary_id_608b2b15` FOREIGN KEY (`diary_id`) REFERENCES `api_diary` (`id`),
  CONSTRAINT `api_topicreply_hospital_id_1f2301c8b8ebc642_fk_api_hospital_id` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`),
  CONSTRAINT `commented_reply_id_refs_id_74e636b9` FOREIGN KEY (`commented_reply_id`) REFERENCES `api_topicreply` (`id`),
  CONSTRAINT `doctor_id_refs_id_38d9d35f` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`),
  CONSTRAINT `problem_id_refs_id_8ba3214` FOREIGN KEY (`problem_id`) REFERENCES `api_problem` (`id`),
  CONSTRAINT `replied_topic_id_refs_id_74e636b9` FOREIGN KEY (`replied_topic_id`) REFERENCES `api_topicreply` (`id`),
  CONSTRAINT `user_id_refs_id_63267d72` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24266559 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_topicreplyvote`
--

DROP TABLE IF EXISTS `api_topicreplyvote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_topicreplyvote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vote_time` datetime NOT NULL,
  `topic_reply_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_topicreplyvote_user_id_3136c1b568331e8_uniq` (`user_id`,`topic_reply_id`),
  KEY `api_topicre_topic_reply_id_1b1b20a205b64523_fk_api_topicreply_id` (`topic_reply_id`),
  KEY `idx_vote_time` (`vote_time`),
  CONSTRAINT `api_topicreplyvote_user_id_665d94aada9276df_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`),
  CONSTRAINT `api_topicre_topic_reply_id_1b1b20a205b64523_fk_api_topicreply_id` FOREIGN KEY (`topic_reply_id`) REFERENCES `api_topicreply` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=766120 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_topicscore`
--

DROP TABLE IF EXISTS `api_topicscore`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_topicscore` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `score` int(11) DEFAULT NULL,
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `topic_id` (`topic_id`,`user_id`),
  KEY `api_topicscore_57732028` (`topic_id`),
  KEY `api_topicscore_403f60f` (`user_id`),
  CONSTRAINT `topic_id_refs_id_68532856` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`),
  CONSTRAINT `user_id_refs_id_3e4c5a84` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=285753 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_topicvote`
--

DROP TABLE IF EXISTS `api_topicvote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_topicvote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `topic_id` int(11) NOT NULL,
  `vote_time` datetime NOT NULL,
  `unread` tinyint(1) DEFAULT '1',
  `is_fake` tinyint(1) DEFAULT '0',
  `topic_author_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_topicvote_user_id_3dacbf995ceed38_uniq` (`user_id`,`topic_id`),
  KEY `api_topicvote_fbfc09f1` (`user_id`),
  KEY `api_topicvote_57732028` (`topic_id`),
  KEY `idx_vote_time` (`vote_time`),
  KEY `api_topicvote_2ca580c4` (`topic_author_id`),
  CONSTRAINT `topic_id_refs_id_93df6853` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`),
  CONSTRAINT `user_id_refs_id_27531a67` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9174659 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_video_white_list`
--

DROP TABLE IF EXISTS `api_video_white_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_video_white_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  CONSTRAINT `user_id_refs_id_c5839f6f` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=881 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `api_votepk`
--

DROP TABLE IF EXISTS `api_votepk`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_votepk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) NOT NULL,
  `person_id` char(32) NOT NULL,
  `vote_date` datetime(6) DEFAULT NULL,
  `vote_doctor_id` varchar(100) DEFAULT NULL,
  `vote_user_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_doctor_date` (`topic_id`,`person_id`,`vote_date`)
) ENGINE=InnoDB AUTO_INCREMENT=2314 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_wechatmaterial`
--

DROP TABLE IF EXISTS `api_wechatmaterial`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_wechatmaterial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `material_id` varchar(128) NOT NULL,
  `number` int(11) NOT NULL,
  `thumb_media_id` varchar(128) NOT NULL,
  `thumb_url` varchar(256) NOT NULL,
  `show_cover_pic` tinyint(1) NOT NULL,
  `author` varchar(128) NOT NULL,
  `digest` varchar(128) NOT NULL,
  `content` longtext NOT NULL,
  `url` varchar(256) NOT NULL,
  `content_source_url` varchar(256) NOT NULL,
  `update_time` datetime(6) NOT NULL,
  `name` varchar(128) NOT NULL,
  `title` varchar(256) NOT NULL,
  `topic_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `material_id` (`material_id`,`number`),
  KEY `api_wechatmaterial_76f18ad3` (`topic_id`),
  CONSTRAINT `topic_id_refs_id_b2c64f70` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5053 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `api_zhiboconfig`
--

DROP TABLE IF EXISTS `api_zhiboconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_zhiboconfig` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(10) NOT NULL,
  `foreshowcover_img` varchar(128) NOT NULL,
  `foreshowpage_img` varchar(128) NOT NULL,
  `anchor_user_id` int(11) NOT NULL,
  `start_time` datetime(6) NOT NULL,
  `end_time` datetime(6) NOT NULL,
  `zhibo_time` datetime(6) NOT NULL,
  `is_online` tinyint(1) NOT NULL,
  `is_shouyejingxuan` tinyint(1) DEFAULT '0',
  `is_shouyezhibo` tinyint(1) DEFAULT '0',
  `is_zhiboliebiao` tinyint(1) DEFAULT '0',
  `full_desc` varchar(500) DEFAULT NULL,
  `adorder_id` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `anchor_user_id_refs_id_9338efc3` (`anchor_user_id`),
  CONSTRAINT `anchor_user_id_refs_id_9338efc3` FOREIGN KEY (`anchor_user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `community_article`
--

DROP TABLE IF EXISTS `community_article`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `community_article` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `banner` varchar(128) NOT NULL,
  `description` longtext NOT NULL,
  `start_time` datetime(6) NOT NULL,
  `end_time` datetime(6) DEFAULT NULL,
  `is_online` tinyint(1) NOT NULL,
  `type` varchar(1) NOT NULL,
  `topic_id` int(11) DEFAULT NULL,
  `send_channel_type` varchar(1) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `topic_id_refs_id_9e7693ef` (`topic_id`),
  CONSTRAINT `topic_id_refs_id_9e7693ef` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=205 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `community_topic_sticky`
--

DROP TABLE IF EXISTS `community_topic_sticky`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `community_topic_sticky` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) NOT NULL,
  `desc` varchar(200) NOT NULL,
  `ordering` int(11) NOT NULL,
  `is_online` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic_id_refs_id_dbbd9cd6` (`topic_id`),
  CONSTRAINT `topic_id_refs_id_dbbd9cd6` FOREIGN KEY (`topic_id`) REFERENCES `api_problem` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relation_usertagrelation`
--

DROP TABLE IF EXISTS `relation_usertagrelation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `relation_usertagrelation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `related_tag_id` int(11) NOT NULL,
  `tag_type` varchar(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `relation_usertagrelation_unique_index` (`user_id`,`related_tag_id`,`tag_type`),
  KEY `fk_relation_usertagrelation_tag` (`related_tag_id`),
  CONSTRAINT `fk_relation_usertagrelation_tag` FOREIGN KEY (`related_tag_id`) REFERENCES `api_tag` (`id`),
  CONSTRAINT `fk_relation_usertagrelation_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5503013 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `social_feed`
--

DROP TABLE IF EXISTS `social_feed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `social_feed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `item_type` varchar(1) NOT NULL,
  `feed_reason` varchar(1) NOT NULL,
  `add_time` datetime(6) DEFAULT NULL,
  `reason_count` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_social_feed_uid_item_id` (`uid`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=173995223 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `social_userfollow`
--

DROP TABLE IF EXISTS `social_userfollow`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `social_userfollow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bond` tinyint(1) NOT NULL,
  `update_time` datetime(6) DEFAULT NULL,
  `follow_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_virtual_fan` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_userfollow_user_id_65ad777f97e593ed_uniq` (`user_id`,`follow_id`),
  KEY `IDX_FOLLOW_ID_BOND` (`follow_id`,`bond`),
  KEY `IDX_UPDATE_TIME` (`update_time`),
  CONSTRAINT `social_userfollow_follow_id_37582002b3e24b6c_fk_auth_user_id` FOREIGN KEY (`follow_id`) REFERENCES `auth_user` (`id`),
  CONSTRAINT `social_userfollow_user_id_6014aa2444a08908_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13651359 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;