-- Deploy mimas-talos:talos_2019_04_04_tractate_add_extra_table to mysql

BEGIN;

alter table `api_tractate_favor` add column `is_read` bool NOT NULL;
alter table `api_tractate` add column `audit_time` datetime(6) NULL;

alter table `api_tractate_images`
  add column `width` integer NOT NULL DEFAULT 0,
  add column `height` integer NOT NULL DEFAULT 0;

alter table `api_tractate_video`
  add column `video_cover_url` varchar(300) NULL DEFAULT '',
  add column `width` integer NOT NULL DEFAULT 0,
  add column `height` integer NOT NULL DEFAULT 0;


CREATE TABLE `api_tractate_check` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tractate_id` integer NOT NULL, `user_id` integer NOT NULL,
	`content_level` varchar(12) NOT NULL,
	`status` varchar(12) NOT NULL,
	`check_content` longtext NOT NULL,
	`title` varchar(128) NOT NULL,
	`send_message` longtext NOT NULL,
	`check_time` datetime(6) NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_tractate_message` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`title` varchar(128) NOT NULL,
	`description` varchar(50) NOT NULL,
	`message` longtext NOT NULL,
	`content_level` varchar(12) NOT NULL,
	`is_delete` bool NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL
);


CREATE TABLE `api_tractate_reply` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tractate_id` integer NOT NULL,
	`user_id` integer NOT NULL,
	`top_id` integer NOT NULL,
	`replied_id` integer NOT NULL,
	`content` varchar(512) NOT NULL,
	`source_id` varchar(12) NOT NULL,
	`is_read` bool NOT NULL,
	`is_online` bool NOT NULL,
	`vote_num` integer NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_tractate_reply_vote` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tractate_id` integer NOT NULL,
	`user_id` integer NOT NULL,
	`reply_id` integer NOT NULL,
	`is_read` bool NOT NULL,
	`is_fake` bool NOT NULL,
	`is_online` bool NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_tractate_report` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`user_id` integer NOT NULL,
	`source_id` integer NOT NULL,
	`source_status` varchar(12) NOT NULL,
	`report_type` varchar(1) NOT NULL,
	`reason` varchar(12) NOT NULL,
	`action` varchar(12) NOT NULL,
	`is_handled` bool NOT NULL,
	`report_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL
);

CREATE TABLE `api_tractate_vote` (
	`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	`tractate_id` integer NOT NULL,
	`user_id` integer NOT NULL,
	`is_read` bool NOT NULL,
	`is_fake` bool NOT NULL,
	`is_online` bool NOT NULL,
	`create_time` datetime(6) NOT NULL,
	`update_time` datetime(6) NOT NULL
);


ALTER TABLE `api_tractate_vote` ADD CONSTRAINT `api_tractate_vote_user_id_2116e54b_uniq` UNIQUE (`user_id`, `tractate_id`);
ALTER TABLE `api_tractate_reply_vote` ADD CONSTRAINT `api_tractate_reply_vote_user_id_d1a68245_uniq` UNIQUE (`user_id`, `tractate_id`, `reply_id`);

CREATE INDEX `api_tractate_check_5f3745c8` ON `api_tractate_check` (`tractate_id`);
CREATE INDEX `api_tractate_reply_5f3745c8` ON `api_tractate_reply` (`tractate_id`);
CREATE INDEX `api_tractate_reply_e8701ad4` ON `api_tractate_reply` (`user_id`);
CREATE INDEX `api_tractate_reply_fb6fedd0` ON `api_tractate_reply` (`top_id`);
CREATE INDEX `api_tractate_reply_90ea0cfb` ON `api_tractate_reply` (`replied_id`);
CREATE INDEX `api_tractate_reply_vote_5f3745c8` ON `api_tractate_reply_vote` (`tractate_id`);
CREATE INDEX `api_tractate_reply_vote_bbc2f847` ON `api_tractate_reply_vote` (`reply_id`);
CREATE INDEX `api_tractate_report_e8701ad4` ON `api_tractate_report` (`user_id`);
CREATE INDEX `api_tractate_report_0afd9202` ON `api_tractate_report` (`source_id`);
CREATE INDEX `api_tractate_vote_5f3745c8` ON `api_tractate_vote` (`tractate_id`);




COMMIT;
