# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function
from talos.rpc import bind
from talos.models.diary import DiaryScanRecord


@bind('diary/get_last_diary_scan_record')
def get_last_diary_scan_record():
    diary_scan_record = DiaryScanRecord.objects.last()
    return {"last_diary_id": diary_scan_record and diary_scan_record.diary_id or 0}


@bind('diary/save_diary_scan_record')
def save_diary_scan_record(diary_id=None, before_img=None, after_img=None, nose=None, eye=None, lip=None,
                           eyebrow=None, face=None, gender=None, age=None, template=None):
    record = DiaryScanRecord()
    record.diary_id = diary_id
    record.before_img = before_img
    record.after_img = after_img
    record.nose = nose
    record.eyebrow = eyebrow
    record.eye = eye
    record.lip = lip
    record.face = face
    record.gender = gender
    record.age = age
    record.template = template
    record.save()
    return {"diary_id": record.diary_id}
