from gm_types.error import ERROR as CODES
from gm_types.gaia import REPLYOBJECT
from gm_rpcd.all import bind

from talos.decorators import list_interface
from talos.cache.base import reply_cache as reply_msg_cache
from talos.tools.replies_tool import ReplyTool
from utils.rpc import gen, get_current_user


@bind('mimas/reply/received')
@list_interface(offset_name='start_num', limit_name='count')
def reply_received(start_num=0, count=10):

    user = get_current_user()
    if not user:
        return gen(CODES.LOGIN_REQUIRED)

    result = []

    reply_tool = ReplyTool(reply_msg_cache, user.id)
    for r in reply_tool.get_replies_received(start_num, count):

        _id, _type = r

        if _type in REPLYOBJECT:
            result.append((_type, int(_id)))

    return result

