from __future__ import unicode_literals, absolute_import, print_function

import random

from gm_protocol import GmProtocol
from gm_types.push import PUSH_INFO_TYPE, AUTOMATED_PUSH
from gm_types.error import ERROR
from gm_types.gaia import (
    CONST_STRINGS,
    LIST_TRACTATE_FROM,
)
from gm_types.mimas import TRACTATE_DATA_TYPE

from gm_rpcd.all import bind

from talos.cache.base import vote_cache
from utils.push import vote_push
from talos.services.user import UserService
from talos.services.soft_article.soft_article import SoftArticleService
from talos.services.soft_article.reply import SoftArticleReplyService
from talos.services.soft_article.vote import SoftArticleReplyVoteService, SoftArticleVoteService
from talos.tools.vote_tool import VoteTool
from talos.services import DoctorService
from utils.rpc import gen, get_current_user


class Test():
    pass


@bind('mimas/soft_article_vote/create')
def create_vote(reply_id):
    """医生后台点赞"""

    reply = SoftArticleReplyService.get_by_id(pk=reply_id)
    soft_article = SoftArticleService.get_by_id(pk=reply.softarticle_id)
    reply.is_vote = True
    reply.save()
    user = UserService.get_user_by_user_id(user_id=reply.user_id)

    doctor_user_id = UserService.get_user_id_by_doctor_id(doctor_id=soft_article.doctor_id)
    reply, reply_vote = SoftArticleReplyVoteService.create(user_id=doctor_user_id, reply=reply)
    vote_num = SoftArticleReplyService.inc_reply_vote(reply)

    # vote_tool = VoteTool(redis_c=vote_cache, user_id=reply.user_id, new_version=True)
    # vote_tool.receive_soft_article_reply_vote(reply_vote.id)
    # 消息推送
    if reply.user_id:
        push_url = GmProtocol().get_tractate_detail(
            comment_id=reply_id,
            tractate_id=reply_vote.softarticle_id,
            data_type=TRACTATE_DATA_TYPE.DOCTOR,
            tractate_detail_from=LIST_TRACTATE_FROM.NOTICE_VOTE
        )
        vote_push(
            user_id=reply.user_id,
            push_url=push_url,
            alert=u'{user_name}赞了你的回复{content}'.format(
                user_name=str(user.nickname), content=reply.content[:10]
            ),
            push_type=AUTOMATED_PUSH.TRACTATE_REPLY_GET_VOTED
        )

    return {
        "vote_amount": vote_num
    }


@bind('mimas/soft_article_vote/cancel')
def reply_cancel_vote(reply_id):
    """
    医生后台回复取消点赞
    :param reply_id:
    :return:
    """

    reply = SoftArticleReplyService.healthy(reply_id)
    reply.is_vote = False
    reply.save()
    soft_article = SoftArticleService.get_by_id(pk=reply.softarticle_id)
    doctor_user_id = UserService.get_user_id_by_doctor_id(doctor_id=soft_article.doctor_id)

    SoftArticleReplyVoteService.cancel(doctor_user_id, reply)
    vote_num = SoftArticleReplyService.dec_reply_vote(reply)

    return {
        "vote_amount": vote_num
    }


@bind('mimas/soft_article/vote')
def create(soft_article_id):
    """
    用户点赞
    :return:
    """
    user = get_current_user()
    if not user:
        return gen(ERROR.LOGIN_REQUIRED)

    soft_article = SoftArticleService.healthy(soft_article_id)
    tv = SoftArticleVoteService.create(softarticle_id=soft_article.id, user_id=user.id)
    # 对作者添加点赞数
    doctor_user_id = UserService.get_user_id_by_doctor_id(doctor_id=soft_article.doctor_id)
    author = UserService.get_user_by_user_id(doctor_user_id)
    author.incr_vote_count()

    vote_num = SoftArticleService.inc_soft_article_vote(soft_article.id)

    # vote_tool = VoteTool(redis_c=vote_cache, user_id=doctor_user_id, new_version=True)
    # vote_tool.receive_soft_article_vote(tv.id)

    return {
        "vote_amount": vote_num
    }


@bind('mimas/soft_article/vote_cancel')
def cancel(soft_article_id):
    """
    新帖子取消点赞
    :return:
    """
    user = get_current_user()
    if not user:
        return gen(ERROR.LOGIN_REQUIRED)

    soft_article = SoftArticleService.healthy(soft_article_id)
    tv = SoftArticleVoteService.cancel(soft_article_id, user.id)

    doctor_user_id = UserService.get_user_id_by_doctor_id(doctor_id=soft_article.doctor_id)
    author = UserService.get_user_by_user_id(doctor_user_id)
    author.decr_vote_count()

    vote_num = SoftArticleService.dec_soft_article_vote(soft_article.id)

    # vote_tool = VoteTool(redis_c=vote_cache, user_id=doctor_user_id, new_version=True)
    # vote_tool.receive_soft_article_vote(tv.id)

    return {
        "vote_amount": vote_num
    }


@bind('mimas/soft_article/reply_vote')
def reply_vote_create(reply_id):
    """
    回复点赞
    :return:
    """
    user = get_current_user()
    if not user:
        return gen(ERROR.LOGIN_REQUIRED)

    reply = SoftArticleReplyService.healthy(reply_id)
    reply, reply_vote = SoftArticleReplyVoteService.create(user_id=user.id, reply=reply)

    vote_num = SoftArticleReplyService.inc_reply_vote(reply)

    if reply.user_id:
        # vote_tool = VoteTool(redis_c=vote_cache, user_id=reply.user_id, new_version=True)
        # vote_tool.receive_soft_article_reply_vote(reply_vote.id)
        # 消息推送
        push_url = GmProtocol().get_tractate_detail(
            comment_id=reply_id,
            tractate_id=reply_vote.softarticle_id,
            data_type=TRACTATE_DATA_TYPE.DOCTOR,
            tractate_detail_from=LIST_TRACTATE_FROM.NOTICE_VOTE
        )
        vote_push(
            user_id=reply.user_id,
            push_url=push_url,
            alert=u'{user_name}赞了你的回复{content}'.format(
                user_name=str(user.nick_name), content=reply.content[:10]
            ),
            push_type=AUTOMATED_PUSH.TRACTATE_REPLY_GET_VOTED
        )

    return {
        "vote_amount": vote_num
    }


@bind('mimas/soft_article/reply_vote_cancel')
def reply_vote_cancel(reply_id):
    """
    新帖子回复取消点赞
    :param reply_id:
    :return:
    """
    user = get_current_user()
    if not user:
        return gen(ERROR.LOGIN_REQUIRED)

    reply = SoftArticleReplyService.healthy(reply_id)
    SoftArticleReplyVoteService.cancel(user.id, reply)
    vote_num = SoftArticleReplyService.dec_reply_vote(reply)

    return {
        "vote_amount": vote_num
    }


@bind('mimas/soft_article/read_votes')
def soft_article_read_all():
    """
    更新未读消息状态
    :return:
    """
    user = get_current_user()
    if not user:
        return gen(ERROR.LOGIN_REQUIRED)

    SoftArticleVoteService.set_read_by_user_id(user.id)


@bind('mimas/soft_article/read_reply_votes')
def soft_article_reply_read_all():
    """
    更新未读消息状态
    :return:
    """
    user = get_current_user()
    if not user:
        return gen(ERROR.LOGIN_REQUIRED)

    SoftArticleVoteService.set_read_by_user_id(user.id)


@bind('mimas/soft_article/unread_count')
def soft_article_unread_num(soft_article_id):
    """
    点赞未读数
    :return:
    """
    count = SoftArticleVoteService.unread_count(softarticle_id=soft_article_id)

    return {'count': count}
