# -*- coding: utf-8 -*-

from django.db.models import Q

from gm_rpcd.all import bind

from gm_types.mimas import TRACTATE_CONTENT_LEVEL, TRACTATE_STATUS
from talos.services.tractate import TractateService


@bind('mimas/tractate/select_list')
def list_tractates_for_select(offset=0, count=10, user_ids=None, tractate_id=None):
    """获取帖子"""

    result = {
        "tractates": [],
    }

    if not user_ids:
        return result

    query = Q(is_online=True, user_id__in=user_ids,
              content_level__in=[TRACTATE_CONTENT_LEVEL.EXCELLENT, TRACTATE_CONTENT_LEVEL.OUTSTANDING],
              status=TRACTATE_STATUS.AUDIT_SUCCESS)
    if tractate_id:
        query &= Q(pk=tractate_id)

    tractates = TractateService.get_tractate_objs_by_query_and_order(query=query,
                                                                     order_by=["id"], offset=offset, size=count)

    result["tractates"] = list(tractates.values("id", "content"))

    return result