from gm_rpcd.all import bind
from gm_types.error import ERROR

from qa.service import QaFavorServices
from talos.models.diary import DiaryFavor
from talos.models.topic import ProblemFavor
from talos.services.tractate import TractateFavorService
from utils.rpc import gen


@bind('mimas/user_follow/count')
def get_user_follow_count(user_id):
    if not user_id:
        return gen(ERROR.LOGIN_REQUIRED)
    trac_count = TractateFavorService.get_favor_count(user_id)
    diary_count = DiaryFavor.get_favor_count(user_id)
    topic_count = ProblemFavor.get_favor_count(user_id)
    answer_count = QaFavorServices.get_favor_answer_count(user_id=user_id)

    return {
        'count': trac_count + diary_count + topic_count + answer_count.get('count')
    }

