from multiprocessing import Pool

from .init_user_rights_base import *


@trace_unhandled_exceptions
def process_buy_service(line):
    _d = json.loads(line)
    # 剔除脏数据
    if not _d['author_id']:
        return

    push_event(event_type=EventType.BUYSERVICE, trigger_time=_d['trigger_time'],
                user_id=_d['author_id'], pre_payment=_d['payment'], item_id=_d['order_id'])


class Command(BaseCommand):

    def handle(self, *args, **options):
        # service
        print('------start-----')
        start_time = time.time()
        print(start_time)

        with open(path_base + 'service_infos.txt', 'r') as f:
            lines = f.readlines()
            pool = Pool(processes=4)
            pool.map(process_buy_service, lines)
            pool.close()
            pool.join()

        end_time = time.time()
        print(end_time)
        print('use {} s'.format(end_time - start_time))
        print('Done!')

