import json

from django.core.management import BaseCommand
from gm_types.user_hierarchy import EventType

from user_hierarchy.models import GrowthTask


class Command(BaseCommand):
    def handle(self, *args, **options):
        tasks = []
        # 发布日记帖
        _event = json.dumps({'events': [EventType.CREATENONOPERATIONTOPIC,
                                        EventType.CREATEOPERATIONTOPIC]})
        tasks.append({
            'title': '发布术后日记帖子',
            'content': '真实图片3张，内容30字以上',
            'result': '+50成长值',
            'is_daily': True,
            'events': _event,
        })

        # 日记本标志为优质
        _event = json.dumps({'events': [EventType.NONOPERATIONDIARYBEEXCELENTFROMFINE,
                                       EventType.NONOPERATIONDIARYBEEXCELENTFROMOTHER,
                                       EventType.OPERATIONDIARYBEEDEXCELENTFROMOTHER,
                                       EventType.OPERATIONDIARYBEEDEXCELENTFROMFINE]})
        tasks.append({
            'title': '日记本标志为优质',
            'content': '日记本被平台选为优质内容',
            'result': '+50成长值',
            'is_daily': True,
            'events': _event,
        })
        # 日记本标志为良好
        _event = json.dumps({'events': [EventType.NONOPERATIONDIARYBEFINEFROMOTHER,
                                        EventType.NONOPERATIONDIARYBEFINEFROMEX,
                                        EventType.OPERATIONDIARYBEFINEFROMEX,
                                        EventType.OPERATIONDIARYBEFINEFROMOTHER]})
        tasks.append({
            'title': '日记本标志为良好',
            'content': '日记本被平台选为良好内容',
            'result': '+50成长值',
            'is_daily': True,
            'events': _event,
        })
        # 去评论日记本
        _event = json.dumps({'events': [EventType.COMMENTDIARY]})
        tasks.append({
            'title': '去评论日记本',
            'content': '评论他人发布的日记本',
            'result': '+5成长值',
            'is_daily': True,
            'events': _event,
        })
        # 去评论日记帖
        _event = json.dumps({'events': [EventType.COMMENTTOPIC]})
        tasks.append({
            'title': '去评论日记帖',
            'content': '评论他人发布的帖子',
            'result': '+5成长值',
            'is_daily': True,
            'events': _event,
        })
        # 优质问答
        _event = json.dumps({'events': [EventType.ANSWERRECOMMENDED, EventType.QUESTIONRECOMMENDED]})
        tasks.append({
            'title': '优质问答（问题／答案）',
            'content': '发现频道进行提问与回答',
            'result': '+30成长值',
            'is_daily': True,
            'events': _event,
        })
        # 完善头像
        _event = json.dumps({'events': [EventType.COMPLETEPORTRAIT]})
        tasks.append({
            'title': '完善头像',
            'content': '首次在设置中修改头像',
            'result': '+10成长值',
            'is_daily': False,
            'events': _event,
        })
        # 注册成功更美账号
        _event = json.dumps({'events': [EventType.BINDPHONE]})
        tasks.append({
            'title': '注册成功更美账号',
            'content': '注册账号，首次绑定手机号',
            'result': '+20成长值',
            'is_daily': False,
            'events': _event,
        })
        for task in tasks:
            GrowthTask.objects.create(**task)

        print('Done!')
