import datetime
from django.core.management import BaseCommand
from user_hierarchy.models import UserEventLog


class Command(BaseCommand):

    def handle(self, *args, **options):
        start = 0
        step = 500

        while True:
            ulogs = UserEventLog.objects.order_by('-id')[start: start + step]
            if len(ulogs) <= 0:
                break

            for ul in ulogs:
                print(ul.id, '\n')
                if not ul.created_time:
                    continue
                print('before %s\n' % ul.created_time)
                ul.created_time += datetime.timedelta(hours=8)
                print('after %s\n' % ul.created_time)
                ul.save()

            start += step
