# coding:utf-8

import hashlib
import json

import requests


"""图片相关"""


info_suffix = '-imageinfo'


class PictureTools(object):

    @staticmethod
    def info(url):
        try:
            img_info = json.loads(requests.get(url=url + info_suffix).text)
            return img_info
        except:
            return {}

    @classmethod
    def is_dynamic(cls, url):
        from .cache import picture_tool_cache

        if not url:
            return False

        encode_url = url
        if not isinstance(url, bytes):
            encode_url = url.encode('utf-8')

        k = hashlib.md5(encode_url).hexdigest()
        raw = picture_tool_cache.get(k)
        if raw is not None:
            is_dynamic = True if int(raw) else False
            return is_dynamic

        img_info = cls.info(url)
        print(img_info)
        fmt = img_info.get("format", '')
        is_dynamic = True if fmt.lower() in ('gif', 'webp') else False

        picture_tool_cache.set(k, int(is_dynamic))

        return is_dynamic
