import threading

threadlocal = threading.local()


def get_thread_local(attr, default=None):
    """ use this method from lower in the stack to get the value """
    return getattr(threadlocal, attr, default)


class ThreadLocalRouter(object):
    """A router to control all database operations base on threadlocal variables.
    """

    def db_for_read(self, model, **hints):
        return get_thread_local('DB_FOR_READ_OVERRIDE')

    def db_for_write(self, model, **hints):
        return get_thread_local('DB_FOR_WRITE_OVERRIDE')

    def allow_relation(self, obj1, obj2, **hints):
        return None

    def allow_migrate(self, db, app_label, model_name=None, **hints):
        return None


class DorisRouter(object):

    def db_for_read(self, model, **hints):
        if model._meta.app_label == "doris":
            return 'doris'
        return None

    def db_for_write(self, model, **hints):
        if model._meta.app_label == "doris":
            return 'doris'
        return None

    def allow_relation(self, obj1, obj2, **hints):
        return None

    def allow_migrate(self, db, app_label, model_name=None, **hints):

        return None

