#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from pytz import timezone
from datetime import datetime
from django.http import HttpResponse
import json
import hashlib


def tzlc(dt, truncate_to_sec=True):
    if dt is None:
        return None
    if truncate_to_sec:
        dt = dt.replace(microsecond=0)

    if dt.tzinfo is None:
        return timezone(settings.TIME_ZONE).localize(dt)
    else:
        return timezone(settings.TIME_ZONE).normalize(dt)


def json_http_response(result, status=200, extra_headers=None):
    if extra_headers is None:
        extra_headers = dict()
    if 'extra' not in result:
        result['extra'] = {}
    response = HttpResponse(
        json.dumps(result),
        content_type="application/json; charset=UTF-8",
        status=status,
    )
    for header_key, header_value in extra_headers.items():
        response[header_key] = header_value
    return response


def getMd5Digest(ori_content):
    m5 = hashlib.md5()
    m5.update(ori_content.encode("utf-8"))
    return m5.hexdigest()