#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.core.management.base import BaseCommand
import traceback
import logging

from libs.table_scan import TableSlicer
from associate.type_info import tips_attr_sync_to_redis_type_info_map


class Command(BaseCommand):
    args = ''
    help = 'dump data to redis, parallel'

    from optparse import make_option

    option_list = BaseCommand.option_list + (
        make_option('-t', '--type', dest='type', help='type name to dump data to elasticsearch', metavar='TYPE',
                    default=''),
        make_option('-i', '--index-prefix', dest='index_prefix', help='index name to dump data to elasticsearch',
                    metavar='INDEX_PREFIX'),
        make_option('-p', '--parallel', dest='parallel', help='parallel process count', metavar='PARALLEL'),
        make_option('-s', '--pks', dest='pks', help='specify sync pks, comma separated', metavar='PKS', default=''),
        make_option('--streaming-slicing', dest='streaming_slicing', action='store_true', default=True),
        make_option('--no-streaming-slicing', dest='streaming_slicing', action='store_false', default=True),
        make_option('-S', '--sync_type', dest='sync_type', help='sync data to es', metavar='TYPE', default='')
    )

    def handle(self, *args, **options):
        try:
            type_name_list = tips_attr_sync_to_redis_type_info_map().keys()
            logging.info("get type_name:%s" % type_name_list)
            for type_name in type_name_list:
                if len(options["type"]):
                    logging.info("get optime:%s" % options["type"])
                    if options["type"] == "all" or type_name == options["type"]:

                        logging.info("begin sync [%s] data to redis!" % type_name)
                        type_info = tips_attr_sync_to_redis_type_info_map()[type_name]
                        query_set = type_info.queryset
                        slicer = TableSlicer(queryset=query_set, chunk_size=type_info.bulk_insert_chunk_size)
                        for chunk in slicer.chunks():
                            for instance in list(chunk):
                                logging.info("get instance:%s" % instance)
                                type_info.get_data_func(instance)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
