#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys, re
import logging
import traceback
from libs.tools import tzlc, getMd5Digest
from libs.es import ESPerform
from libs.cache import redis_client
import json
from trans2es.models.doctor import Doctor
from trans2es.commons.commons import get_tips_suggest_list, get_tips_suggest_list_v1
from trans2es.commons.words_utils import QueryWordAttr, get_tips_word_type


class HospitalTransfer(object):

    @classmethod
    def get_hospital_suggest_data_list(cls, instance):
        try:
            ret_list = list()
            name = instance.name.strip()
            cut_bool = False
            cut_word = ["下线", "停用", "已经下线", "账号停用"]
            for i in cut_word:
                if name.find(i) >= 0:
                    cut_bool = True

            item_dict = dict()
            suggest_list = list()
            if cut_bool == False:
                item_dict = dict()
                # item_dict["id"] = getMd5Digest(str(name))
                item_dict["id"] = "hospital_" + str(instance.id)
                item_dict["ori_name"] = name
                # item_dict["is_online"] = by_hospital_id_judge_office_online(is_online=instance.is_online,
                #                                                             hospital_id=instance.id, name=name)
                item_dict["is_online"] = instance.is_online
                item_dict["order_weight"] = QueryWordAttr.get_hospital_query_word_weight(name=name,
                                                                                         hospital_id=instance.id)
                item_dict["results_num"] = QueryWordAttr.get_query_results_num(name)
                item_dict["type_flag"] = get_tips_word_type(name)
                item_dict["offline_score"] = 0.0
                item_dict["tips_name_type"] = 1

                ret_list.append(item_dict)

                suggest_list = get_tips_suggest_list(str(name).lower())

            return (item_dict, suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return (dict(), list())

    @classmethod
    def get_hospital_lat_lng_info_to_redis(cls, instance):
        try:
            redis_key_prefix = "search_tips:hospital_latlng_info"
            name = instance.name.strip()
            lng = instance.baidu_loc_lng
            lat = instance.baidu_loc_lat

            pos_list = [lng, lat]
            redis_client.hset(redis_key_prefix, name, pos_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())


class HospitalTransferV1(object):

    @classmethod
    def get_hospital_suggest_data_list(cls, instance):
        try:
            ret_list = list()
            name = instance.name.strip()
            cut_bool = False
            cut_word = ["下线", "停用", "已经下线", "账号停用"]
            for i in cut_word:
                if name.find(i) >= 0:
                    cut_bool = True

            item_dict = dict()
            suggest_list = list()
            if cut_bool == False:
                item_dict = dict()
                # item_dict["id"] = getMd5Digest(str(name))
                item_dict["id"] = "hospital_" + str(instance.id)
                item_dict["ori_name"] = name
                # item_dict["is_online"] = by_hospital_id_judge_office_online(is_online=instance.is_online,
                #                                                             hospital_id=instance.id, name=name)
                item_dict["is_online"] = instance.is_online
                item_dict["order_weight"] = QueryWordAttr.get_hospital_query_word_weight(name=name,
                                                                                         hospital_id=instance.id)
                item_dict["results_num"] = QueryWordAttr.get_query_results_num(name)
                item_dict["type_flag"] = get_tips_word_type(name)
                item_dict["offline_score"] = 0.0
                item_dict["tips_name_type"] = 1

                ret_list.append(item_dict)

                suggest_list = get_tips_suggest_list(str(name).lower())

            return (item_dict, suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return (dict(), list())

    @classmethod
    def get_hospital_lat_lng_info_to_redis(cls, instance):
        try:
            redis_key_prefix = "search_tips:hospital_latlng_info"
            name = instance.name.strip()
            lng = instance.baidu_loc_lng
            lat = instance.baidu_loc_lat

            pos_list = [lng, lat]
            redis_client.hset(redis_key_prefix, name, pos_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())


def by_hospital_id_judge_office_online(is_online=False, hospital_id=None, name=None):
    try:
        office = Doctor.objects.filter(is_online=True, doctor_type=1, hospital_id=hospital_id)
        if office:
            return True
        return False
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
