#!/usr/bin/env python
# -*- coding: utf-8 -*-
import logging
import traceback, re
from libs.tools import getMd5Digest
from trans2es.commons.words_utils import QueryWordAttr, get_tips_word_type
from trans2es.commons.commons import get_tips_suggest_list_v1
from trans2es.models.strategy_search_word import StrategyHistoryQueryWords
from trans2es.utils.itemwiki_transfer import ItemWikiTransfer
from trans2es.utils.tag_transfer import TagTransfer
from trans2es.utils.doctor_transfer import DoctorTransfer
from trans2es.models import wordresemble
from trans2es.utils.wordresemble import WordResemble


class SearchWord(object):

    @classmethod
    def get_search_query(self, instance):
        try:
            ret_list = list()
            item_dict = dict()
            suggest_list = list()
            sub_query = re.sub('\W+', '', instance.keyword)
            keyword = str(sub_query).lower()
            ret_bol = QueryWordAttr.save_query_to_redis(query=sub_query)
            is_online = False
            if ret_bol:
                # item_dict["id"] = getMd5Digest(keyword)
                item_dict["id"] = "search_query_" + str(instance.id)
                item_dict["ori_name"] = keyword
                # total_num = QueryWordAttr.get_search_query_results_num(keyword)
                # if total_num > 3:
                #     is_online = False if instance.is_delete else True
                # else:
                #     is_online = False

                item_dict["is_online"] = False
                item_dict["order_weight"] = QueryWordAttr.get_hot_search_query_word_weight(keyword)
                item_dict["results_num"] = QueryWordAttr.get_search_query_results_num(keyword)
                item_dict["type_flag"] = get_tips_word_type(keyword)
                item_dict["offline_score"] = 0.0
                item_dict["tips_name_type"] = 5
                ret_list.append(item_dict)
                suggest_list = get_tips_suggest_list_v1(keyword)
            return (item_dict, suggest_list)

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([], [])

    @classmethod
    def get_search_unique(self, instance):
        try:
            ret_list = list()
            item_dict = dict()
            suggest_list = list()
            sub_query = re.sub('\W+', '', instance.keyword)
            keyword = str(sub_query).lower()
            ret_bol = QueryWordAttr.save_query_to_redis(query=sub_query)
            if ret_bol:
                item_dict["id"] = "search_unique_" + str(instance.id)
                item_dict["ori_name"] = keyword
                is_online = False if instance.is_delete else True
                item_dict["is_online"] = is_online
                item_dict["order_weight"] = int(0.01 * instance.uv)
                item_dict["results_num"] = QueryWordAttr.get_query_results_num(keyword)
                item_dict["type_flag"] = "unknown"
                item_dict["offline_score"] = 0.0
                item_dict["tips_name_type"] = 5
                ret_list.append(item_dict)
                suggest_list = get_tips_suggest_list_v1(keyword)
            return (item_dict, suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([], [])

    @classmethod
    def get_search_query_v1(self, instance):

        try:
            ret_list = list()
            item_dict = dict()
            suggest_list = list()
            sub_query = re.sub('\W+', '', instance.keyword)
            keyword = str(sub_query).lower()
            ret_bol = QueryWordAttr.save_query_to_redis(query=sub_query, type_v1=True)
            if ret_bol:
                # item_dict["id"] = getMd5Digest(keyword)
                item_dict["id"] = "search_query_" + str(instance.id)
                item_dict["ori_name"] = keyword
                # if QueryWordAttr.get_search_query_results_num(keyword):
                #     is_online = False if instance.is_delete else True
                # else:
                #     is_online = False
                item_dict["is_online"] = False
                item_dict["order_weight"] = QueryWordAttr.get_hot_search_query_word_weight(keyword)
                item_dict["results_num"] = QueryWordAttr.get_search_query_results_num(keyword)
                item_dict["type_flag"] = get_tips_word_type(keyword)
                item_dict["offline_score"] = 0.0
                item_dict["tips_name_type"] = 5
                ret_list.append(item_dict)
                suggest_list = get_tips_suggest_list_v1(keyword)
            return (item_dict, suggest_list)

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([], [])

    @classmethod
    def set_data_to_redis(cls, instance):
        try:
            total_count = 0
            instance.name = instance.keyword
            # 获取百科的
            ItemWikiTransfer.get_wiki_data_name_mapping_results_to_redis(instance)

            # 获取美购的
            TagTransfer.get_tag_data_name_mapping_results_to_redis(instance)

            # 获取医生医院的
            DoctorTransfer.get_doctor_data_name_mapping_results_to_redis(instance)

            # 获取日记的
            WordResemble.get_diary_data_name_mapping_results_to_redis(instance)

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
