#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
import logging
import traceback
from libs.es import ESPerform


def get_suggest_tips(query, agile_tag_type):
    try:
        # ios输入法在某些情况下会携带\\u2006

        if agile_tag_type == 1:
            index_name = "associate_tag_project"
        elif agile_tag_type == 2:
            index_name = "associate_tag_position"
        elif agile_tag_type == 3:
            index_name = "associate_tag_brand"
        elif agile_tag_type == 4:
            index_name = "associate_tag_instrument"
        elif agile_tag_type == 5:
            index_name = "associate_tag_hospital"
        elif agile_tag_type == 6:
            index_name = "associate_tag_doctor"
        else:
            index_name = 'associate_tag'

        query = query.replace("\u2006", '')
        q = {
            "suggest": {
                "tips-suggest": {
                    "prefix": query,
                    "completion": {
                        "field": "suggest",
                        "size": 50,
                        "contexts": {
                            "is_online": [True]
                        },
                        "fuzzy": {
                            "fuzziness": 0
                        }
                    }
                }
            }
        }

        logging.info("get qqqqqqqq:%s" % q)
        have_read_tips_set = set()
        ret_list = list()
        result_dict = ESPerform.get_search_results(ESPerform.get_cli(), sub_index_name=index_name, query_body=q,
                                                   offset=0, size=50, is_suggest_request=True)

        agile_type_id = set()
        logging.info("get agile_tag_type:%s" % agile_tag_type)
        if agile_tag_type > 0:
            q = {
                "query": {
                    "term": {
                        "agile_tag_type": agile_tag_type
                    }
                }
            }
            result_dicts = ESPerform.get_search_results(ESPerform.get_cli(), sub_index_name="associate_tag",
                                                        query_body=q,
                                                        offset=0, size=100, is_suggest_request=True)
            logging.info("get result_dict_type:%s" % result_dicts)
            for tips_item in result_dicts["hits"]["hits"]:
                agile_type_id.add(tips_item["_source"]["agile_tag_id"])

        logging.info("get agile_type_id:%s" % agile_type_id)
        # 获取这个类型

        logging.info("get result_dict:%s" % result_dict)
        for tips_item in result_dict["suggest"]["tips-suggest"]:
            for hit_item in tips_item["options"]:
                if hit_item["_source"]["ori_name"] not in have_read_tips_set:
                    agile_tag_id = hit_item["_source"]["agile_tag_id"]
                    if agile_tag_id in agile_type_id:
                        have_read_tips_set.add(hit_item["_source"]["ori_name"])
                        highlight_marks = u'<ems>%s</ems>' % query
                        hit_item["_source"]["highlight_name"] = hit_item["_source"]["ori_name"].replace(query,
                                                                                                        highlight_marks)
                        ori_name = hit_item["_source"]["ori_name"]
                        results_num = hit_item["_source"]["results_num"]
                        highlight_name = hit_item["_source"]["highlight_name"]

                        ret_list.append(
                            [{"ori_name": ori_name, "results_num": results_num, "highlight": highlight_name}])

        return ret_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return list()
