from __future__ import unicode_literals, absolute_import, print_function

# !/usr/bin/env python
# -*- coding: utf-8 -*-
import logging
import traceback
import base64
from django.db import models
from gm_types.gaia import (
    AGILE_TAG_TYPE,
    AGILE_TAG_CREATE_TYPE,
    AGILE_TAG_STYLE,
    AGILE_TAG_RECOMMEND_TYPE,
)


class BaseModel(models.Model):
    class Meta:
        abstract = True

    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class AgileTag(BaseModel):
    class Meta:
        verbose_name = u'新标签'
        db_table = 'api_agile_tag'
        app_label = 'api'

    name = models.CharField(verbose_name=u'新标签名字', max_length=128, null=False, unique=True, default='')
    description = models.TextField(verbose_name=u'描述', default='')
    create_tag_type = models.CharField(verbose_name=u"标签创建类型", max_length=3, choices=AGILE_TAG_CREATE_TYPE)
    style = models.CharField(verbose_name=u"标签样式", max_length=3, choices=AGILE_TAG_STYLE)
    topic_recommend_sort = models.IntegerField(verbose_name=u'帖子推荐排序', default=9999)

    def get_agile_tag_type(self):
        try:
            results = AgileTagType.objects.filter(agile_tag_id=self.id).values_list("agile_tag_type", flat=True).first()
            return results
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None

    def get_api_agile_tag_recommend_type(self):
        try:
            results = AgileTagRecommendType.objects.filter(agile_tag_id=self.id).values_list("agile_tag_type",
                                                                                             flat=True).first()
            return results
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None


class AgileTagType(BaseModel):
    class Meta:
        verbose_name = u'新标签类型(可多选)'
        db_table = 'api_agile_tag_type'
        app_label = 'api'

    agile_tag_id = models.IntegerField(verbose_name=u'新标签', db_index=True)
    agile_tag_type = models.CharField(verbose_name=u"标签类型", max_length=3, choices=AGILE_TAG_TYPE)


class AgileTagRecommendType(BaseModel):
    class Meta:
        verbose_name = u'新标签推荐类型'
        db_table = 'api_agile_tag_recommend_type'

    agile_tag_id = models.IntegerField(verbose_name=u'新标签', db_index=True)
    agile_tag_type = models.CharField(verbose_name=u"标签推荐类型", max_length=3, choices=AGILE_TAG_RECOMMEND_TYPE)
    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)
