#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
import logging
import traceback
import json
import base64
from libs.es import ESPerform
from libs.cache import redis_client
from libs.tools import g_hospital_pos_dict
from libs.tools import point_distance
from gm_rpcd.all import bind
from trans2es.commons.words_utils import QueryWordAttr, get_tips_word_type
from pypinyin import pinyin, lazy_pinyin


def get_suggest_tips(query, lat, lng, offset=0, size=50):
    try:
        have_read_tips_set, ret_list, result_dict = get_query_by_es(query=str(query).lower(), lat=lat, lng=lng,
                                                                    offset=offset,
                                                                    size=size, highlight_query=query)
        if len(ret_list) >= 50:
            return ret_list

        else:
            query_ret_list = []
            wordresemble_ret_list = []
            value_data = []
            QUERY_KEY = "query:search_tip"
            query_base64 = base64.b64encode(query.encode('utf8')).decode('utf8')
            if redis_client.hget(QUERY_KEY, query_base64) is not None:
                value_data = json.loads(str(redis_client.hget(QUERY_KEY, query_base64), encoding='utf-8'))

            if len(value_data) > 0:
                for i in value_data:
                    key = list(i.keys())[0]
                    ori_name = str(base64.b64decode(key), "utf-8")
                    if ori_name not in have_read_tips_set:
                        have_read_tips_set.add(ori_name)
                        result_num = i.get(key, 0)
                        describe = "约" + str(result_num) + "个结果" if result_num else ""
                        logging.info("get result_num:%s" % result_num)
                        highlight_marks = u'<ems>%s</ems>' % query
                        # highlight_name = ori_name.replace(query, highlight_marks)
                        highlight_name = set_highlihgt(query, ori_name)
                        if ori_name == query:
                            query_ret_list.append(
                                {"results_num": result_num, "ori_name": ori_name, "id": None, "is_online": True,
                                 "offline_score": 0,
                                 "type_flag": get_tips_word_type(ori_name), "highlight_name": highlight_name,
                                 "describe": describe})
                        else:

                            wordresemble_ret_list.append(
                                {"results_num": result_num, "ori_name": ori_name, "id": None, "is_online": True,
                                 "offline_score": 0,
                                 "type_flag": get_tips_word_type(ori_name), "highlight_name": highlight_name,
                                 "describe": describe})

                ret_list.extend(query_ret_list)
                ret_list.extend(wordresemble_ret_list)
            ###繁体字删掉，把搜索结果加到简体字上边
            fanti_query = [{'痩脸针': "瘦脸针"}]

            for item in ret_list:
                result_num = [[item['results_num'], list(ret.values())[0], list(ret.keys())[0]] for ret in fanti_query
                              if list(ret.keys())[0] == item['ori_name']]

                if len(result_num) > 0:
                    ret_list.remove(item)
                    for item in ret_list:
                        if item['ori_name'] == result_num[0][1]:
                            item['results_num'] += result_num[0][0]

            ####
            if len(ret_list) >= 50:
                return ret_list[0:50]
            elif len(ret_list) < 50 and len(ret_list) > 0:
                return ret_list
            else:
                ##无结果的时候把汉字转成拼音再搜一次
                ss = lazy_pinyin(query)
                str_query = ''
                for item in ss:
                    str_query += str(item)

                have_read_tips_set, ret_list, result_dict = get_query_by_es(query=str_query, lat=lat, lng=lng,
                                                                            offset=offset,
                                                                            size=size, highlight_query=query)

                logging.info("get ret_list:%s" % ret_list)
                return ret_list


    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return list()


def set_highlihgt(query=None, ori_name=None):
    ###高亮调整
    all_word = set()
    query2 = ori_name
    for item in range(0, len(query)):
        all_word.add(query[item])
    for item in all_word:
        is_find = query2.find(item)
        if is_find >= 0:
            highlight_marks = u'<>%s</>' % item
            high_query = query2.replace(item, highlight_marks)
            query2 = high_query

        highlight_name = query2.replace('<>', '<ems>').replace('</>', '</ems>')

    return highlight_name


def get_query_by_es(query='', lat=0, lng=0, size=0, offset=0, highlight_query=None):
    try:

        query = query.replace("\u2006", '')
        q = {
            "suggest": {
                "tips-suggest": {
                    "prefix": query,
                    "completion": {
                        "field": "suggest",
                        "size": size,
                        "contexts": {
                            "is_online": [True]
                        },
                        "fuzzy": {
                            "fuzziness": 0
                        }
                    }
                }
            },
            "_source": {
                "includes": ["id", "ori_name", "offline_score", "is_online", "type_flag", "results_num"]
            }
        }
        get_doctor_hospital_data = list()
        get_tag_wiki_data = list()
        have_read_tips_set = set()
        ret_list = list()
        doctor_hospital_equal_query = list()
        tag_equal_query = list()
        result_dict = ESPerform.get_search_results(ESPerform.get_cli(), sub_index_name="suggest", query_body=q,
                                                   offset=offset, size=size, is_suggest_request=True)

        for tips_item in result_dict["suggest"]["tips-suggest"]:
            for hit_item in tips_item["options"]:

                logging.info("get hit_item:%s" % hit_item)
                if hit_item["_source"]["ori_name"] not in have_read_tips_set:
                    have_read_tips_set.add(hit_item["_source"]["ori_name"])
                    highlight_marks = u'<ems>%s</ems>' % query
                    # hit_item["_source"]["highlight_name"] = hit_item["_source"]["ori_name"].replace(query,
                    #                                                                                 highlight_marks)
                    hit_item["_source"]["highlight_name"] = set_highlihgt(highlight_query,
                                                                          hit_item["_source"]["ori_name"])
                    if hit_item["_source"]["type_flag"] == "hospital":
                        if lat is not None and lng is not None and lat != 0.0 and lng != 0.0:
                            if hit_item["_source"]["ori_name"] in g_hospital_pos_dict:
                                distance = point_distance(lng, lat,
                                                          g_hospital_pos_dict[hit_item["_source"]["ori_name"]][0],
                                                          g_hospital_pos_dict[hit_item["_source"]["ori_name"]][1])
                                if distance < 1000 * 50:
                                    if distance < 1000:
                                        if distance < 100:
                                            hit_item["_source"]["describe"] = "<100" + "米"
                                        else:
                                            hit_item["_source"]["describe"] = "约" + str(int(distance)) + "米"
                                    else:
                                        hit_item["_source"]["describe"] = "约" + str(
                                            round(1.0 * distance / 1000, 1)) + "km"
                                else:
                                    hit_item["_source"]["describe"] = ">50km"
                            else:
                                hit_item["_source"]["describe"] = ""

                        else:
                            hit_item["_source"]["describe"] = ""

                        if hit_item["_source"]["ori_name"] == query:
                            doctor_hospital_equal_query.append(hit_item["_source"])
                        else:
                            get_doctor_hospital_data.append(hit_item["_source"])

                    else:
                        if hit_item["_source"]["type_flag"] == "doctor":
                            hit_item["_source"]["describe"] = ""

                            if hit_item["_source"]["ori_name"] == query:
                                doctor_hospital_equal_query.append(hit_item["_source"])
                            else:
                                get_doctor_hospital_data.append(hit_item["_source"])
                        else:
                            hit_item["_source"]["describe"] = "约" + str(hit_item["_source"]["results_num"]) + "个结果" if \
                                hit_item["_source"]["results_num"] else ""
                            if hit_item["_source"]["ori_name"] == query:
                                tag_equal_query.append(hit_item["_source"])
                            else:
                                get_tag_wiki_data.append(hit_item["_source"])

            ret_list.extend(tag_equal_query)
            ret_list.extend(doctor_hospital_equal_query)
            ret_list.extend(get_tag_wiki_data)
            ret_list.extend(get_doctor_hospital_data)

        return have_read_tips_set, ret_list, result_dict
    except:

        return set(), list(), list()
