# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

import operator

from django.db import models
from django.db.models import Q
from django.db import transaction
from gm_types.gaia import TAG_ALERT_TYPE

from django.utils import timezone
from gm_upload import IMG_TYPE, ImgUrlField
from gm_types.gaia import (
    DOCTOR_PROCESS_STATUS, DOCTOR_TYPE, PHONE_HINTS, TOPIC_TYPE, TAG_TYPE, DisplayTag,
    SERVICE_FLAG)

class Tag(models.Model):

    class Meta:
        verbose_name = "标签"
        verbose_name_plural = "标签"
        app_label = 'api'

    #objects = TagManager()

    name = models.CharField(
        verbose_name='名称',
        max_length=64,
        null=False,
        blank=False,
        db_index=True,
        unique=True,
    )
    tag_type = models.CharField(
        verbose_name='标签类型',
        max_length=4,
        null=False,
        blank=False,
        choices=TAG_TYPE,
    )
    is_online = models.BooleanField(null=False, default=True, verbose_name='是否上线')
