#!/usr/bin/env python
# -*- coding: utf-8 -*-
import logging
import traceback
from libs.tools import getMd5Digest
from trans2es.commons.words_utils import QueryWordAttr, get_tips_word_type
from trans2es.commons.commons import get_tips_suggest_list


class SearchWord(object):

    @classmethod
    def get_search_query(self, instance):
        try:
            ret_list = list()
            item_dict = dict()
            item_dict["id"] = getMd5Digest(str(instance.keyword))
            item_dict["ori_name"] = instance.keyword
            item_dict["is_online"] = False if instance.is_delete else True
            item_dict["order_weight"] = QueryWordAttr.get_project_query_word_weight(instance.keyword)
            item_dict["results_num"] = QueryWordAttr.get_query_results_num(instance.keyword)
            item_dict["type_flag"] = get_tips_word_type(instance.keyword)
            item_dict["offline_score"] = 0.0
            item_dict["tips_name_type"] = 5
            ret_list.append(item_dict)
            suggest_list = get_tips_suggest_list(str(instance.keyword).lower(), is_weighting=True)
            return (item_dict, suggest_list)

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([], [])
