#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc,getMd5Digest
from libs.es import ESPerform
from libs.cache import redis_client
import json

from trans2es.commons.commons import get_tips_suggest_list
from trans2es.commons.words_utils import QueryWordAttr


class TagTransfer(object):

    test_es_info_list = [
        {'host': '10.30.57.94', 'port': 9200}
    ]
    tips_num_redis_key_prefix = "search_tips:tips_mapping_num"

    @classmethod
    def get_tag_data_name_mapping_results_to_redis(cls, instance):
        try:
            tag_name = instance.name.strip()
            q = dict()
            if tag_name:
                multi_fields = {
                    'short_description': 1,
                    'doctor.name': 1,
                    'doctor.hospital.name': 1,
                    'doctor.hospital.city_name': 1,
                    'doctor.hospital.city_province_name': 1,
                    'closure_tags': 1,  # 5.9版 搜索所有tag
                    'doctor.hospital.officer_name': 1  # 搜索机构管理者
                }
                query_fields = ['^'.join((k, str(v))) for (k, v) in multi_fields.items()]
                multi_match = {
                    'query': tag_name,
                    'type': 'cross_fields',
                    'operator': 'and',
                    'fields': query_fields,
                }
                sku_query = {
                    "nested": {
                        "path": "sku_list",
                        "query": {
                            "multi_match": {
                                "query": tag_name,
                                "fields": ["sku_list.name^2"],
                                'operator': 'and',
                                'type': 'cross_fields'
                            }
                        }
                    }
                }

                q['query'] = {
                    "size":0,
                    'bool': {
                        "should": [
                            {'multi_match': multi_match},
                            sku_query
                        ],
                        "must":[
                            {"term":{"is_online":True}}
                        ],
                        "minimum_should_match": 1
                    }
                }

                result_dict = ESPerform.get_search_results(ESPerform.get_cli(cls.test_es_info_list), sub_index_name="service", doc_type="service", query_body=q,offset=0,size=0)

                doctor_results = result_dict["total_count"]

                redis_data = redis_client.hget(cls.tips_num_redis_key_prefix, tag_name)

                redis_val_dict = json.loads(str(redis_data,encoding="utf-8")) if redis_data else {}

                total_count = doctor_results
                if 's' in redis_val_dict:
                    total_count += int(redis_val_dict['s'])

                redis_val_dict['t'] = total_count
                redis_val_dict['s'] = doctor_results

                redis_client.hset(cls.tips_num_redis_key_prefix,tag_name, json.dumps(redis_val_dict))
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())

    @classmethod
    def get_tag_suggest_data_list(cls, instance):
        try:
            ret_list = list()

            item_dict = dict()
            item_dict["id"] = getMd5Digest(str(instance.name))
            item_dict["ori_name"] = instance.name
            item_dict["is_online"] = instance.is_online

            item_dict["order_weight"] = QueryWordAttr.get_project_query_word_weight(instance.name)
            item_dict["results_num"] = QueryWordAttr.get_query_results_num(instance.name)
            item_dict["type_flag"] = "project"
            item_dict["offline_score"] = 0.0
            item_dict["tips_name_type"] = 0

            ret_list.append(item_dict)

            suggest_list = get_tips_suggest_list(instance.name)

            return (item_dict,suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([],[])