#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
import base64
from libs.tools import tzlc, getMd5Digest
from libs.es import ESPerform
from libs.cache import redis_client
import json
from django.conf import settings
from trans2es.models import wordresemble
from trans2es.commons.words_utils import QueryWordAttr, get_tips_word_type
from trans2es.commons.commons import get_tips_suggest_list
from trans2es.utils.doctor_transfer import DoctorTransfer
from trans2es.utils.itemwiki_transfer import ItemWikiTransfer
from trans2es.utils.tag_transfer import TagTransfer


class SearchWord(object):

    @classmethod
    def get_search_query(self):
        try:
            ##先拿到所有存在redis的数据存进es
            key = "search_tips_save_query_word"
            data = redis_client.get(key)
            if data:
                redis_data = json.loads(data, encoding="utf-8")

            for key, value in redis_data.items():
                ret_list = list()
                item_dict = dict()
                item_dict["id"] = getMd5Digest(str(key))
                item_dict["ori_name"] = key
                item_dict["is_online"] = 1

                item_dict["order_weight"] = QueryWordAttr.get_project_query_word_weight(key)
                item_dict["results_num"] = QueryWordAttr.get_query_results_num(key)
                item_dict["type_flag"] = get_tips_word_type(key)
                item_dict["offline_score"] = 0.0
                item_dict["tips_name_type"] = 5
                ret_list.append(item_dict)
                suggest_list = get_tips_suggest_list(str(key).lower())
                return (item_dict, suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([], [])
