#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime



class Doctor(models.Model):
    class Meta:
        verbose_name = u'31. 医生'
        verbose_name_plural = u'31. 医生'
        db_table = 'api_doctor'
        app_label = 'api'

    id = models.CharField(max_length=100, primary_key=True)
    name = models.CharField(max_length=200, verbose_name=u"姓名", db_index=True)
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线", db_index=True)


