# -*- coding: UTF-8 -*-
import logging
from celery import shared_task
from trans2es.type_info import get_type_info_map
import logging
import traceback
import base64
from libs.cache import redis_client
import json
from trans2es.models import wordresemble


@shared_task
def set_data_to_redis():
    try:
        QUERY_KEY = "query:{}:search_tips"
        tips_num_redis_key_prefix = "search_tips:tips_mapping_num"

        result = wordresemble.WordRel.objects.all().values("keyword", "id")
        for wordrm in result:
            query_sql_item = wordresemble.WordRel.objects.filter(keyword=wordrm["keyword"])
            for sql_obj in query_sql_item:
                words = list(sql_obj.all_resembles.all().values_list('word', flat=True))
                for items in words:
                    # 先存储本体词
                    logging.info("get wordrm:%s" % wordrm["keyword"])
                    logging.info("get words:%s" % words)
                    query_base64 = base64.b64encode(wordrm["keyword"].encode('utf8')).decode('utf8')
                    key = QUERY_KEY.format(query_base64)
                    value_name = base64.b64encode(items.encode('utf8')).decode('utf8')

                    # 获取本体词的结果
                    redis_data = redis_client.hget(tips_num_redis_key_prefix, items)
                    redis_val_dict = json.loads(str(redis_data, encoding="utf-8")) if redis_data else {}
                    total_count = 0
                    if 't' in redis_val_dict:
                        total_count = int(redis_val_dict['t'])
                    # 存储到Redis
                    value = value_name + str(":" + str(total_count))
                    redis_client.sadd(key, value)
                    logging.info("get value:%s" % value)

                    # 存储近义词
                    query_base64 = base64.b64encode(items.encode('utf8')).decode('utf8')
                    key = QUERY_KEY.format(query_base64)
                    value_name = base64.b64encode(wordrm["keyword"].encode('utf8')).decode('utf8')
                    # 获取结果
                    redis_data = redis_client.hget(tips_num_redis_key_prefix, wordrm["keyword"])
                    redis_val_dict = json.loads(str(redis_data, encoding="utf-8")) if redis_data else {}
                    total_count = 0
                    if 't' in redis_val_dict:
                        total_count = int(redis_val_dict['t'])
                    # 存储结果
                    value = value_name + str(":" + str(total_count))
                    redis_client.sadd(key, value)
                    logging.info("get value:%s" % value)
                    if words:
                        for w in words:
                            logging.info("get word_pops:%s" % words)
                            value_name = base64.b64encode(w.encode('utf8')).decode('utf8')
                            redis_data = redis_client.hget(tips_num_redis_key_prefix, w)
                            redis_val_dict = json.loads(str(redis_data, encoding="utf-8")) if redis_data else {}
                            total_count = 0
                            if 't' in redis_val_dict:
                                total_count = int(redis_val_dict['t'])
                            value = value_name + str(":" + str(total_count))
                            redis_client.sadd(key, value)
                            logging.info("get value:%s" % value)


    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
