#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.es import ESPerform
from libs.cache import redis_client
from libs.tools import json_http_response
from associate.search.utils.auto_tips import get_suggest_tips


@bind("associate/search/auto_complete_query")
def auto_complete_query(query, agile_tag_type=-1):
    try:
        """auto complate words/tags/doctors etc.

        URL:
            ~/api/auto_complete?scope=[kw]&q=双

        Return:
            {'error': 0|1, 'data': [word, word, word],}
        """

        # q = request.GET.get('q', '').strip()
        # if not q:
        #     return json_http_response({'error': 0, 'data': []})

        data = get_suggest_tips(query, agile_tag_type)

        result = {
            'error': 0,
            'data': data,
        }
        return result
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"error": 1, "data": []}
