#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
from associate.commons.words_utils import QueryWordAttr


@bind("associate/search/tag_hotword_num")
def get_hotword_num(tag_id_list):
    try:
        tag_id_num = list()
        for id in tag_id_list:
            result = QueryWordAttr.get_query_results_num(id)
            tag_id_num.append({"tag_id": id, "hot_num": result})
        return {"tag_hotword_num": tag_id_num}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"tag_hotword_num": []}
