#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime
from gm_types.gaia import (
    DOCTOR_PROCESS_STATUS, DOCTOR_TYPE, PHONE_HINTS, TOPIC_TYPE, TAG_TYPE, DisplayTag,
    SERVICE_FLAG)
from trans2es.commons.commons import uuid4


class Hospital(models.Model):
    class Meta:
        verbose_name = u'30. 医院'
        verbose_name_plural = u'30. 医院'
        db_table = 'api_hospital'
        app_label = 'api'

    id = models.CharField(max_length=100, primary_key=True, default=uuid4)
    name = models.CharField(max_length=100, unique=True, help_text=u"医院名称")
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线")

    google_loc_lng = models.FloatField(default=0, help_text=u"经度(-180~180)")
    google_loc_lat = models.FloatField(default=0, help_text=u"纬度")
    baidu_loc_lng = models.FloatField(default=0, help_text=u"经度(-180~180)")
    baidu_loc_lat = models.FloatField(default=0, help_text=u"纬度")


class Doctor(models.Model):
    class Meta:
        verbose_name = u'31. 医生'
        verbose_name_plural = u'31. 医生'
        db_table = 'api_doctor'
        app_label = 'api'

    id = models.CharField(max_length=100, primary_key=True)
    name = models.CharField(max_length=200, verbose_name=u"姓名", db_index=True)
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线", db_index=True)
    doctor_type = models.CharField(max_length=1, default=DOCTOR_TYPE.DOCTOR,
                                   choices=DOCTOR_TYPE, null=False,
                                   verbose_name=u'医生类型')
    hospital = models.ForeignKey(Hospital, null=True, blank=False, related_name="doctor_hospital", verbose_name=u"医院")


class Service(models.Model):
    class Meta:
        verbose_name = u'福利'
        verbose_name_plural = u'福利'
        db_table = 'api_service'
        app_label = 'api'

    name = models.CharField(max_length=100, null=False, verbose_name=u'福利名称')
    short_description = models.CharField(max_length=100, null=False, verbose_name=u'一句话描述')
    detail_description = models.TextField(max_length=2000, verbose_name=u'详细描述')
    doctor = models.ForeignKey(Doctor, related_name='services')
    phone = models.CharField(max_length=20, null=True, blank=True, verbose_name=u'服务电话')
    is_online = models.BooleanField(default=False, help_text=u"是否上线", verbose_name=u"上线")


