#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from trans2es.type_info import get_type_info_map, TypeInfo


class Command(BaseCommand):
    args = ''
    help = 'dump mapping to elasticsearch'

    from optparse import make_option

    option_list = BaseCommand.option_list + (
        make_option('-t', '--type', dest='type', help='type name to dump data to elasticsearch', metavar='TYPE',
                    default=''),
        make_option('-T', '--indices_template', dest='indices_template',
                    help='index template name to dump data to elasticsearch', metavar='TYPE',
                    default=''),
        make_option('-i', '--index-prefix', dest='index_prefix', help='index name to dump data to elasticsearch',
                    metavar='INDEX_PREFIX'),
        make_option('-p', '--parallel', dest='parallel', help='parallel process count', metavar='PARALLEL'),
        make_option('-s', '--pks', dest='pks', help='specify sync pks, comma separated', metavar='PKS', default=''),
        make_option('--streaming-slicing', dest='streaming_slicing', action='store_true', default=True),
        make_option('--no-streaming-slicing', dest='streaming_slicing', action='store_false', default=True),
    )

    def handle(self, *args, **options):
        try:
            es_cli = ESPerform.get_cli()

            type_name_list = get_type_info_map().keys()
            for type_name in type_name_list:

                if len(options["type"]):
                    if options["type"] == "all" or type_name == options["type"]:
                        official_index_name = ESPerform.get_official_index_name(type_name)
                        index_exists = es_cli.indices.exists(official_index_name)
                        if not index_exists:
                            logging.info("begin create [%s] index!" % type_name)
                            ESPerform.create_index(es_cli, type_name)

                        logging.info("begin create [%s] mapping!" % type_name)
                        ESPerform.put_index_mapping(es_cli, type_name)

            if len(options["indices_template"]):
                template_file_name = options["indices_template"]
                if ESPerform.put_indices_template(es_cli=es_cli, template_file_name=template_file_name,
                                                  template_name=template_file_name):
                    logging.info("put indices template suc!")
                else:
                    logging.error("put indices template err!")
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
