#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc, getMd5Digest
from libs.es import ESPerform
from libs.cache import redis_client
import json

from trans2es.commons.commons import get_tips_suggest_list, get_tips_suggest_list_v1
from trans2es.commons.words_utils import QueryWordAttr, get_tips_word_type


class CollectWikiTransfer(object):

    @classmethod
    def get_collectwiki_suggest_data_list(cls, instance):
        try:
            ret_list = list()
            item_dict = dict()
            suggest_list = list()
            ret_bol = QueryWordAttr.save_query_to_redis(query=str(instance.name))
            if ret_bol:
                # item_dict["id"] = getMd5Digest(str(instance.name))
                item_dict["id"] = "collectwiki_" + str(instance.id)
                item_dict["ori_name"] = instance.name
                item_dict["is_online"] = instance.is_online
                item_dict["order_weight"] = QueryWordAttr.get_project_query_word_weight(instance.name)
                item_dict["results_num"] = QueryWordAttr.get_query_results_num(instance.name)
                item_dict["type_flag"] = get_tips_word_type(instance.name)
                item_dict["offline_score"] = 0.0
                item_dict["tips_name_type"] = 3
                ret_list.append(item_dict)
                suggest_list = get_tips_suggest_list(str(instance.name).lower())
            return (item_dict, suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([], [])


class CollectWikiTransferV1(object):

    @classmethod
    def get_collectwiki_suggest_data_list(cls, instance):
        try:
            ret_list = list()
            item_dict = dict()
            suggest_list = list()
            ret_bol = QueryWordAttr.save_query_to_redis(query=str(instance.name), type_v1=True)
            if ret_bol:
                # item_dict["id"] = getMd5Digest(str(instance.name))
                item_dict["id"] = "collectwiki_" + str(instance.id)
                item_dict["ori_name"] = instance.name
                item_dict["is_online"] = instance.is_online
                item_dict["order_weight"] = QueryWordAttr.get_project_query_word_weight(instance.name)
                item_dict["results_num"] = QueryWordAttr.get_query_results_num(instance.name)
                item_dict["type_flag"] = get_tips_word_type(instance.name)
                item_dict["offline_score"] = 0.0
                item_dict["tips_name_type"] = 3
                ret_list.append(item_dict)
                suggest_list = get_tips_suggest_list(str(instance.name).lower())
            return (item_dict, suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([], [])
