# coding=utf-8                                                                           
from __future__ import unicode_literals, print_function, absolute_import
from django.conf import settings
import itertools
import logging


class CeleryTaskRouter(object):
    queue_task_map = {
        "tapir-search_tips": [
            'injection.data_sync.tasks.write_to_es',
        ]
    }

    # Map[TaskName, QueueName]
    task_queue_map = dict(itertools.chain.from_iterable(
        [(task, queue) for task in task_list]
        for (queue, task_list) in queue_task_map.items()
    ))

    def route_for_task(self, task, args=None, kwargs=None):
        """
        if settings.DEBUG:
            return None

        if task.startswith("statistic") or task.startswith("api.tasks.export_excel_task"):
            return "slow"
        """

        queue_name_or_none = self.task_queue_map.get(task)
        return queue_name_or_none


class DorisRouter(object):

    def db_for_read(self, model, **hints):
        if model._meta.app_label == "doris":
            return 'doris'
        return None

    def db_for_write(self, model, **hints):
        if model._meta.app_label == "doris":
            return 'doris'
        return None

    def allow_relation(self, obj1, obj2, **hints):
        if obj1._meta.app_label == 'doris' or \
                obj2._meta.app_label == 'doris':
            return True
        return None

    def allow_migrate(self, db, app_label, model_name=None, **hints):
        if app_label == 'doris':
            return db == 'doris'
        return None
