# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

import datetime


class CollectWiki(models.Model):
    class Meta:
        verbose_name = u'聚合新百科'
        db_table = 'wiki_collect'

    id = models.IntegerField(verbose_name=u'聚合ID', primary_key=True)
    name = models.CharField(u'聚合名称', max_length=48)
    description = models.TextField(u'简介')
    is_online = models.BooleanField(u'是否上线', default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
