# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function
from django.db import models
from django.conf import settings


class StrategyHistoryQueryWords(models.Model):
    """
    历史搜索词
    """

    class Meta:
        app_label = 'doris'
        db_table = 'strategy_history_query_words'

    keyword = models.CharField(u'项目介绍', max_length=48)
    is_delete = models.BooleanField(u'是否上线', default=True)
    search_num = models.IntegerField(verbose_name=u'搜索次数')
    answer_num = models.IntegerField(verbose_name=u'回答搜索结果次数')
    tractate_num = models.IntegerField(verbose_name=u'帖子搜索结果次数')
    diary_num = models.IntegerField(verbose_name=u'日记搜索结果次数')


class StrategyHistoryQueryUnique(models.Model):
    """
        历史搜索词
    """
    class Meta:
        app_label = 'jerry_tidb'
        db_table = 'strategy_history_query_unique'

    keyword = models.CharField(u'项目介绍', max_length=48)
    is_delete = models.IntegerField(u'是否上线', default=True)
    uv = models.IntegerField(verbose_name=u'搜索次数')
